/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.json;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import net.anwiba.commons.json.IJsonObjectMarshallingExceptionFactory;
import net.anwiba.commons.resource.utilities.IoUtilities;

public abstract class AbstractJsonObjectUnmarshaller<T, R, E extends IOException> {
    private final ObjectMapper mapper = new ObjectMapper();
    private final Class<R> errorResponseClass;
    private final IJsonObjectMarshallingExceptionFactory<R, E> exceptionFactory;
    private final Class<T> clazz;
    private final Map<Class, Object> injectionValues = new HashMap<Class, Object>();

    public AbstractJsonObjectUnmarshaller(Class<T> clazz, Class<R> errorResponseClass, Map<Class, Object> injectionValues, IJsonObjectMarshallingExceptionFactory<R, E> exceptionFactory) {
        this.clazz = clazz;
        this.errorResponseClass = errorResponseClass;
        this.injectionValues.putAll(injectionValues);
        this.exceptionFactory = exceptionFactory;
        this.mapper.getFactory().configure(JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS, true);
    }

    public T unmarshal(InputStream inputStream) throws IOException, E {
        return this.unmarshal(IoUtilities.toString((InputStream)inputStream, (String)"UTF-8"));
    }

    public T unmarshal(String body) throws IOException, E {
        T result = this.validate(body);
        if (result != null) {
            return result;
        }
        try {
            return this.read(body, this.clazz);
        }
        catch (JsonParseException exception) {
            throw this.createIOException(body, (Exception)((Object)exception));
        }
        catch (JsonMappingException exception) {
            throw this.createIOException(body, (Exception)((Object)exception));
        }
    }

    private <X> X read(String body, Class<X> type) throws IOException, JsonParseException, JsonMappingException, JsonProcessingException {
        InjectableValues.Std injectableValues = new InjectableValues.Std();
        for (Class key : this.injectionValues.keySet()) {
            injectableValues.addValue(key, this.injectionValues.get(key));
        }
        return (X)this.mapper.readerFor(type).with((InjectableValues)injectableValues).readValue(body);
    }

    private T validate(String body) throws IOException, E {
        if (Void.class.equals(this.errorResponseClass)) {
            return null;
        }
        try {
            R response = this.read(body, this.errorResponseClass);
            if (this.clazz.isInstance(response)) {
                return (T)response;
            }
            throw (IOException)this.exceptionFactory.create(response);
        }
        catch (JsonParseException jsonParseException) {
            return null;
        }
        catch (JsonMappingException jsonMappingException) {
            return null;
        }
    }

    private IOException createIOException(String content, Exception exception) {
        return new IOException(MessageFormat.format("Error during mapping json resource, coudn''t map the content:\n {0}", content), exception);
    }
}

