/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.workflow;

import net.anwiba.commons.lang.object.IObjectReceiver;
import net.anwiba.commons.lang.object.SingleUseObjectReceiver;
import net.anwiba.commons.model.IChangeableObjectListener;
import net.anwiba.commons.model.ObjectModel;
import net.anwiba.commons.workflow.IExecutable;
import net.anwiba.commons.workflow.IExecuterFactory;
import net.anwiba.commons.workflow.IWorkflow;
import net.anwiba.commons.workflow.IWorkflowController;
import net.anwiba.commons.workflow.state.IState;

public final class Workflow<T>
implements IWorkflow<T> {
    private final IExecuterFactory<T> procedureDelegatorFactory;
    private final IWorkflowController<T> controller;

    public Workflow(IExecuterFactory<T> closureDelegatorFactory, IWorkflowController<T> workflowController) {
        this.procedureDelegatorFactory = closureDelegatorFactory;
        this.controller = workflowController;
    }

    @Override
    public void execute(IState<T> state) {
        IExecutable<T> executable = this.controller.next(state);
        if (executable == null) {
            return;
        }
        ObjectModel<IState<T>> stateModel = new ObjectModel<IState<T>>();
        IChangeableObjectListener listener = this.createChangeListener(stateModel);
        stateModel.addChangeListener(listener);
        this.launch(executable, state, stateModel);
    }

    private IChangeableObjectListener createChangeListener(final ObjectModel<IState<T>> stateModel) {
        return new IChangeableObjectListener(){

            @Override
            public void objectChanged() {
                stateModel.removeChangeListener(this);
                Workflow.this.execute((IState)stateModel.get());
            }
        };
    }

    private void launch(IExecutable<T> executable, IState<T> state, ObjectModel<IState<T>> stateModel) {
        IExecutable<T> delegatingClosure = this.procedureDelegatorFactory.create(executable);
        delegatingClosure.execute((IObjectReceiver<IState<T>>)new SingleUseObjectReceiver(stateModel));
    }
}

