/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.image.codec;

import net.anwiba.commons.image.codec.IImageCodecVisitor;
import net.anwiba.commons.utilities.string.StringUtilities;

public enum ImageCodec {
    BMP(false, new String[]{"bmp"}){

        @Override
        public <T, E extends Exception> T accept(IImageCodecVisitor<T, E> visitor) throws E {
            return visitor.visitBmp();
        }
    }
    ,
    GIF(true, new String[]{"gif"}){

        @Override
        public <T, E extends Exception> T accept(IImageCodecVisitor<T, E> visitor) throws E {
            return visitor.visitGif();
        }
    }
    ,
    JPEG(false, new String[]{"jpg", "jpeg"}){

        @Override
        public <T, E extends Exception> T accept(IImageCodecVisitor<T, E> visitor) throws E {
            return visitor.visitJpeg();
        }
    }
    ,
    PNG(true, new String[]{"png"}){

        @Override
        public <T, E extends Exception> T accept(IImageCodecVisitor<T, E> visitor) throws E {
            return visitor.visitPng();
        }
    }
    ,
    TIFF(false, new String[]{"tif", "tiff"}){

        @Override
        public <T, E extends Exception> T accept(IImageCodecVisitor<T, E> visitor) throws E {
            return visitor.visitTiff();
        }
    }
    ,
    UNKNOWN(true, new String[0]){

        @Override
        public <T, E extends Exception> T accept(IImageCodecVisitor<T, E> visitor) throws E {
            return visitor.visitUnknown();
        }
    };

    private final String[] extensions;
    private final boolean isTransparentSupported;

    private ImageCodec(boolean isTransparentSupported, String ... extension) {
        this.isTransparentSupported = isTransparentSupported;
        this.extensions = extension;
    }

    public static ImageCodec getByExtension(String extension) {
        ImageCodec[] imageCodecArray = ImageCodec.values();
        int n = imageCodecArray.length;
        int n2 = 0;
        while (n2 < n) {
            ImageCodec imageCodec = imageCodecArray[n2];
            if (StringUtilities.containsIgnoreCase((String)extension, (String[])imageCodec.extensions)) {
                return imageCodec;
            }
            ++n2;
        }
        return UNKNOWN;
    }

    public abstract <T, E extends Exception> T accept(IImageCodecVisitor<T, E> var1) throws E;

    public String getName() {
        return this.name();
    }

    public boolean isTransparentSupported() {
        return this.isTransparentSupported;
    }

    public String getExtension() {
        if (this.extensions.length == 0) {
            return "*";
        }
        return this.extensions[0];
    }

    public String[] getExtensions() {
        return this.extensions;
    }

    /* synthetic */ ImageCodec(String string, int n, boolean bl, String[] stringArray, ImageCodec imageCodec) {
        this(bl, stringArray);
    }
}

