/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.json;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.anwiba.commons.json.AbstractJsonUnmarshaller;
import net.anwiba.commons.json.IJsonObjectMarshallingExceptionFactory;

public abstract class AbstractJsonObjectUnmarshaller<T, R, E extends IOException>
extends AbstractJsonUnmarshaller<T, T, R, IOException> {
    private final ObjectMapper mapper = new ObjectMapper();
    private final IJsonObjectMarshallingExceptionFactory<R, E> exceptionFactory;
    private final Class<T> clazz;
    private final Map<Class, Object> injectionValues = new HashMap<Class, Object>();

    public AbstractJsonObjectUnmarshaller(Class<T> clazz, Class<R> errorResponseClass, Map<Class, Object> injectionValues, IJsonObjectMarshallingExceptionFactory<R, E> exceptionFactory) {
        super(clazz, errorResponseClass, injectionValues);
        this.clazz = clazz;
        this.injectionValues.putAll(injectionValues);
        this.exceptionFactory = exceptionFactory;
        this.mapper.getFactory().configure(JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS, true);
    }

    @Override
    public T unmarshal(String body) throws IOException, E {
        Object result = this.validate(body);
        if (result != null) {
            return result;
        }
        try {
            return this.read(body, this.clazz);
        }
        catch (JsonParseException exception) {
            throw this.createIOException(body, (Exception)((Object)exception));
        }
        catch (JsonMappingException exception) {
            throw this.createIOException(body, (Exception)((Object)exception));
        }
    }

    private <X> X read(String body, Class<X> type) throws IOException, JsonParseException, JsonMappingException, JsonProcessingException {
        InjectableValues.Std injectableValues = new InjectableValues.Std();
        for (Class key : this.injectionValues.keySet()) {
            injectableValues.addValue(key, this.injectionValues.get(key));
        }
        return (X)this.mapper.readerFor(type).with((InjectableValues)injectableValues).readValue(body);
    }

    @Override
    protected IOException createException(R response) {
        return (IOException)this.exceptionFactory.create(response);
    }
}

