/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.anwiba.commons.json.AbstractJsonUnmarshaller;
import net.anwiba.commons.json.IJsonObjectMarshallingExceptionFactory;

public abstract class AbstractJsonObjectsUnmarshaller<T, R, E extends IOException>
extends AbstractJsonUnmarshaller<T, List<T>, R, IOException> {
    private final ObjectMapper mapper = new ObjectMapper();
    private final IJsonObjectMarshallingExceptionFactory<R, E> exceptionFactory;
    private final Class<T> clazz;
    private final Map<Class, Object> injectionValues = new HashMap<Class, Object>();

    public AbstractJsonObjectsUnmarshaller(Class<T> clazz, Class<R> errorResponseClass, Map<Class, Object> injectionValues, IJsonObjectMarshallingExceptionFactory<R, E> exceptionFactory) {
        super(clazz, errorResponseClass, injectionValues);
        this.clazz = clazz;
        this.injectionValues.putAll(injectionValues);
        this.exceptionFactory = exceptionFactory;
        this.mapper.getFactory().configure(JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<T> unmarshal(String body) throws IOException, E {
        List result = (List)this.validate(body);
        if (result != null) {
            return result;
        }
        try {
            InjectableValues.Std injectableValues = new InjectableValues.Std();
            for (Class key : this.injectionValues.keySet()) {
                injectableValues.addValue(key, this.injectionValues.get(key));
            }
            JsonFactory f = new JsonFactory();
            Object object = null;
            Object var6_9 = null;
            try {
                List list;
                JsonParser parser = f.createParser(body);
                try {
                    ObjectReader reader = this.mapper.readerFor(this.clazz).with((InjectableValues)injectableValues);
                    JsonToken token = parser.nextToken();
                    if (token != JsonToken.START_ARRAY) {
                        list = (List)reader.readValue(parser);
                        return list;
                    }
                    ArrayList<Object> results = new ArrayList<Object>();
                    while (parser.nextToken() == JsonToken.START_OBJECT) {
                        Object value = reader.readValue(parser);
                        results.add(value);
                    }
                    return results;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (parser == null) return list;
                    parser.close();
                }
            }
            catch (Throwable throwable) {
                if (object == null) {
                    object = throwable;
                    throw object;
                }
                if (object == throwable) throw object;
                ((Throwable)object).addSuppressed(throwable);
                throw object;
            }
        }
        catch (JsonParseException exception) {
            throw this.createIOException(body, (Exception)((Object)exception));
        }
        catch (JsonMappingException exception) {
            throw this.createIOException(body, (Exception)((Object)exception));
        }
    }

    @Override
    protected IOException createException(R response) {
        return (IOException)this.exceptionFactory.create(response);
    }
}

