/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.json;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractJsonUnmarshaller<T, O, R, E extends IOException> {
    private final ObjectMapper mapper = new ObjectMapper();
    private final Class<R> errorResponseClass;
    private final Class<T> clazz;
    private final Map<Class, Object> injectionValues = new HashMap<Class, Object>();

    public AbstractJsonUnmarshaller(Class<T> clazz, Class<R> errorResponseClass, Map<Class, Object> injectionValues) {
        this.clazz = clazz;
        this.errorResponseClass = errorResponseClass;
        this.injectionValues.putAll(injectionValues);
        this.mapper.getFactory().configure(JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS, true);
    }

    public O unmarshal(InputStream inputStream) throws IOException, E {
        return this.unmarshal(AbstractJsonUnmarshaller.toString(inputStream, "UTF-8"));
    }

    public static String toString(InputStream inputStream, String contentEncoding) throws IOException {
        int numChars;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        while ((numChars = inputStream.read(buffer)) > 0) {
            out.write(buffer, 0, numChars);
        }
        return out.toString(contentEncoding);
    }

    protected abstract O unmarshal(String var1) throws IOException, E;

    private <X> X check(String body, Class<X> type) throws IOException, JsonParseException, JsonMappingException, JsonProcessingException {
        InjectableValues.Std injectableValues = new InjectableValues.Std();
        for (Class key : this.injectionValues.keySet()) {
            injectableValues.addValue(key, this.injectionValues.get(key));
        }
        return (X)this.mapper.readerFor(type).with((InjectableValues)injectableValues).readValue(body);
    }

    protected T validate(String body) throws IOException, E {
        if (Void.class.equals(this.errorResponseClass)) {
            return null;
        }
        try {
            R response = this.check(body, this.errorResponseClass);
            if (this.clazz.isInstance(response)) {
                return (T)response;
            }
            throw this.createException(response);
        }
        catch (JsonParseException jsonParseException) {
            return null;
        }
        catch (JsonMappingException jsonMappingException) {
            return null;
        }
    }

    protected abstract E createException(R var1);

    protected IOException createIOException(String content, Exception exception) {
        return new IOException(MessageFormat.format("Error during mapping json resource, coudn''t map the content:\n {0}", content), exception);
    }
}

