/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.process.queue;

import net.anwiba.commons.ensure.Ensure;
import net.anwiba.commons.logging.ILevel;
import net.anwiba.commons.logging.ILogger;

public class Condition {
    private final ILogger logger;
    private boolean value;

    public Condition(ILogger logger, boolean value) {
        Ensure.ensureArgumentNotNull((Object)logger);
        this.logger = logger;
        this.value = value;
    }

    public synchronized boolean isTrue() {
        return this.value;
    }

    public synchronized void setFalse() {
        this.logger.log(ILevel.DEBUG, "setting condition to false");
        this.value = false;
    }

    public synchronized void setTrue() {
        this.logger.log(ILevel.DEBUG, "setting condition to true");
        this.value = true;
        this.notifyAll();
    }

    public synchronized void releaseAll() {
        this.notifyAll();
        this.logger.log(ILevel.DEBUG, "released all");
    }

    public synchronized void releaseOne() {
        this.notify();
        this.logger.log(ILevel.DEBUG, "released one");
    }

    public synchronized void waitForTrue(long timeout) throws InterruptedException {
        if (!this.value) {
            this.logger.log(ILevel.DEBUG, "waiting to become true");
            this.wait(timeout);
        }
        if (this.value) {
            this.logger.log(ILevel.DEBUG, "now true");
        } else {
            this.logger.log(ILevel.WARNING, "timed out, condition is still false!");
        }
    }

    public synchronized void waitForTrue() throws InterruptedException {
        this.waitForTrue(0L);
    }
}

