/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.http;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.anwiba.commons.http.ConvertingHttpRequestExecutor;
import net.anwiba.commons.http.HttpClientConnectionManagerProvider;
import net.anwiba.commons.http.HttpRequestExcecutorFactory;
import net.anwiba.commons.http.IApplicableHttpResponseExceptionFactory;
import net.anwiba.commons.http.IConvertingHttpRequestExecutor;
import net.anwiba.commons.http.IConvertingHttpRequestExecutorBuilder;
import net.anwiba.commons.http.IHttpClientConnectionManagerProvider;
import net.anwiba.commons.http.IHttpRequestExecutor;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;

public class ConvertingHttpRequestExecutorBuilder
implements IConvertingHttpRequestExecutorBuilder {
    final List<IApplicableHttpResponseExceptionFactory> applicableHttpResponseExceptionFactories = new ArrayList<IApplicableHttpResponseExceptionFactory>();
    private IHttpClientConnectionManagerProvider connectionManagerProvider;

    @Override
    public IConvertingHttpRequestExecutorBuilder setConnectionManagerProvider(IHttpClientConnectionManagerProvider connectionManagerProvider) {
        this.connectionManagerProvider = connectionManagerProvider;
        return this;
    }

    @Override
    public IConvertingHttpRequestExecutorBuilder useAlwaysTheSameConnection() {
        this.connectionManagerProvider = new HttpClientConnectionManagerProvider((HttpClientConnectionManager)new BasicHttpClientConnectionManager());
        return this;
    }

    @Override
    public IConvertingHttpRequestExecutorBuilder useAlwaysANewConnection() {
        this.connectionManagerProvider = new HttpClientConnectionManagerProvider();
        return this;
    }

    @Override
    public IConvertingHttpRequestExecutor build() {
        IHttpClientConnectionManagerProvider provider = Optional.ofNullable(this.connectionManagerProvider).orElseGet(() -> new HttpClientConnectionManagerProvider());
        IHttpRequestExecutor executor = new HttpRequestExcecutorFactory(provider).create();
        return new ConvertingHttpRequestExecutor(executor);
    }
}

