/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.json.schema.v1_0;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.HashMap;
import net.anwiba.commons.reflection.ReflectionConstructorInvoker;

public class Property {
    private String name = null;
    private String title = null;
    private String description = null;
    private final String type = "property";
    private static final HashMap<String, Class> _classes = new HashMap();

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public static Property create(@JsonProperty(value="type") String type) {
        if (Property._isNullOrTrimmedEmpty(type)) {
            return new Property();
        }
        Class<? extends Property> clazz = Property._createClass(type);
        if (clazz != null) {
            return Property._createBean(clazz);
        }
        clazz = Property._createClass(type.toLowerCase());
        if (clazz != null) {
            return Property._createBean(clazz);
        }
        String className = MessageFormat.format("{0}{1}", type, "Property");
        clazz = Property._createClass(className);
        if (clazz != null) {
            return Property._createBean(clazz);
        }
        className = MessageFormat.format("{0}{1}", type.toLowerCase(), "Property");
        clazz = Property._createClass(className);
        if (clazz != null) {
            return Property._createBean(clazz);
        }
        return new Property();
    }

    private static Property _createBean(Class<? extends Property> clazz) {
        try {
            ReflectionConstructorInvoker invoker = new ReflectionConstructorInvoker(clazz, new Class[0]);
            return (Property)invoker.invoke(new Object[0]);
        }
        catch (InvocationTargetException exception) {
            throw new RuntimeException(exception);
        }
    }

    private static synchronized Class<? extends Property> _createClass(String type) {
        Class<?> clazz;
        block4: {
            if (_classes.containsKey(type)) {
                return _classes.get(type);
            }
            try {
                String packageName = Property.class.getPackage().getName();
                String typeName = Property._setFirstCharacterToUpperCase(type);
                String className = MessageFormat.format("{0}.{1}", packageName, typeName);
                clazz = Class.forName(className);
                if (Property.class.isAssignableFrom(clazz)) break block4;
                _classes.put(type, null);
                return null;
            }
            catch (ClassNotFoundException classNotFoundException) {
                _classes.put(type, null);
                return null;
            }
        }
        _classes.put(type, clazz);
        return clazz;
    }

    private static boolean _isNullOrTrimmedEmpty(String value) {
        return value == null || value.trim().isEmpty();
    }

    private static String _setFirstCharacterToUpperCase(String value) {
        if (value == null || value.trim().isEmpty()) {
            return null;
        }
        return String.valueOf(value.substring(0, 1).toUpperCase()) + value.substring(1, value.length());
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="title")
    public void setTitle(String title) {
        this.title = title;
    }

    @JsonProperty(value="title")
    public String getTitle() {
        return this.title;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="type")
    public String getType() {
        return "property";
    }
}

