/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.lang.hashable;

import java.io.Serializable;
import java.util.AbstractSet;
import java.util.HashSet;
import java.util.Iterator;
import net.anwiba.commons.lang.hashable.HashableWrapper;
import net.anwiba.commons.lang.hashable.IHashable;

public final class HashableSet<V extends IHashable>
extends AbstractSet<V>
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -7023287624783829656L;
    private final HashSet<HashableWrapper<V>> set;

    public HashableSet() {
        this.set = new HashSet();
    }

    public HashableSet(int initialCapacity) {
        this.set = new HashSet(initialCapacity);
    }

    public HashableSet(int initialCapacity, float loadFactor) {
        this.set = new HashSet(initialCapacity, loadFactor);
    }

    HashableSet(HashSet<HashableWrapper<V>> clone) {
        this.set = clone;
    }

    @Override
    public int size() {
        return this.set.size();
    }

    @Override
    public boolean contains(Object object) {
        if (object != null && !(object instanceof IHashable)) {
            return false;
        }
        IHashable hashable = (IHashable)object;
        return this.set.contains(new HashableWrapper<IHashable>(hashable));
    }

    @Override
    public Iterator<V> iterator() {
        final Iterator<HashableWrapper<V>> iterator = this.set.iterator();
        return new Iterator<V>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public V next() {
                return ((HashableWrapper)iterator.next()).getValue();
            }

            @Override
            public void remove() {
                iterator.remove();
            }
        };
    }

    @Override
    public boolean add(V e) {
        return this.set.add(new HashableWrapper<V>(e));
    }

    @Override
    public boolean remove(Object object) {
        if (object != null && !(object instanceof IHashable)) {
            return false;
        }
        IHashable hashable = (IHashable)object;
        return this.set.remove(new HashableWrapper<IHashable>(hashable));
    }

    @Override
    public void clear() {
        this.set.clear();
    }

    public HashableSet<V> clone() {
        return new HashableSet<V>((HashSet)this.set.clone());
    }
}

