/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.lang.optional;

import net.anwiba.commons.lang.functional.IAcceptor;
import net.anwiba.commons.lang.functional.IConverter;
import net.anwiba.commons.lang.object.ObjectUtilities;
import net.anwiba.commons.lang.optional.IOptional;
import net.anwiba.commons.lang.stream.IConsumer;
import net.anwiba.commons.lang.stream.ISupplier;

public class Optional<T, E extends Exception>
implements IOptional<T, E> {
    private final T value;
    private final IAcceptor<T> acceptor;

    private Optional(IAcceptor<T> acceptor, T value) {
        this.acceptor = acceptor;
        this.value = value;
    }

    public static <T, E extends Exception> IOptional<T, E> create(T value) {
        return new Optional<Object, E>(i -> i != null, value);
    }

    @Override
    public T get() throws E {
        if (this.isAccepted()) {
            return this.value;
        }
        return null;
    }

    @Override
    public IOptional<T, E> accept(IAcceptor<T> acceptor) throws E {
        if (this.isAccepted()) {
            return new Optional<T, E>(acceptor, this.value);
        }
        return Optional.create(null);
    }

    private boolean isAccepted() {
        return this.acceptor.accept(this.value);
    }

    @Override
    public <O> IOptional<O, E> convert(IConverter<T, O, E> converter) throws E {
        if (this.isAccepted()) {
            return Optional.create(converter.convert(this.value));
        }
        return Optional.create(null);
    }

    @Override
    public <O> void consum(IConsumer<T, E> consumer) throws E {
        if (this.isAccepted()) {
            consumer.consume(this.value);
        }
    }

    @Override
    public <O> IOptional<T, E> equals(IConverter<T, O, E> converter, O other) throws E {
        if (this.isAccepted() && ObjectUtilities.equals(converter.convert(this.value), other)) {
            return this;
        }
        return Optional.create(null);
    }

    @Override
    public <X extends Exception> T getOrThrow(X throwable) throws E, X {
        if (this.isAccepted()) {
            return this.value;
        }
        throw throwable;
    }

    @Override
    public <X extends Exception> T getOrThrow(ISupplier<X, E> supplier) throws E, X {
        if (this.isAccepted()) {
            return this.value;
        }
        throw (Exception)supplier.supply();
    }

    @Override
    public T getOr(T value) throws E {
        if (this.isAccepted()) {
            return this.value;
        }
        return value;
    }

    @Override
    public T getOr(ISupplier<T, E> supplier) throws E {
        if (this.isAccepted()) {
            return this.value;
        }
        return supplier.supply();
    }
}

