/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.lang.stream;

import java.util.NoSuchElementException;
import net.anwiba.commons.lang.functional.IAcceptor;
import net.anwiba.commons.lang.functional.IConverter;
import net.anwiba.commons.lang.stream.IIterator;

public final class ConvertingIteratorIterator<I, O, E extends Exception>
implements IIterator<O, E> {
    private final IIterator<I, E> iterator;
    private final IAcceptor<I> acceptor;
    private final IConverter<I, O, E> converter;
    private O item = null;

    public ConvertingIteratorIterator(IIterator<I, E> input, IAcceptor<I> acceptor, IConverter<I, O, E> converter) {
        this.iterator = input;
        this.acceptor = acceptor;
        this.converter = converter;
    }

    @Override
    public boolean hasNext() throws E {
        while (this.iterator.hasNext()) {
            I i = this.iterator.next();
            if (!this.acceptor.accept(i)) continue;
            this.item = this.converter.convert(i);
            return true;
        }
        return false;
    }

    @Override
    public O next() throws E {
        try {
            if (this.item != null || this.hasNext()) {
                O o = this.item;
                return o;
            }
            throw new NoSuchElementException();
        }
        finally {
            this.item = null;
        }
    }
}

