/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.lang.stream;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import net.anwiba.commons.lang.collection.IObjectList;
import net.anwiba.commons.lang.collection.ObjectList;
import net.anwiba.commons.lang.functional.IAcceptor;
import net.anwiba.commons.lang.functional.IConverter;
import net.anwiba.commons.lang.functional.IProcedure;
import net.anwiba.commons.lang.optional.IOptional;
import net.anwiba.commons.lang.optional.Optional;
import net.anwiba.commons.lang.stream.ConvertingIterableIterable;
import net.anwiba.commons.lang.stream.FilteringIterableIterable;
import net.anwiba.commons.lang.stream.IAccumulator;
import net.anwiba.commons.lang.stream.IIterable;
import net.anwiba.commons.lang.stream.IIterator;
import net.anwiba.commons.lang.stream.IStream;

class SequencedStream<T, E extends Exception>
implements IStream<T, E> {
    private final IIterable<T, E> iterable;

    SequencedStream(IIterable<T, E> iterable) {
        this.iterable = iterable;
    }

    @Override
    public <O> IStream<O, E> convert(IConverter<T, O, E> converter) {
        return new SequencedStream<T, E>(new ConvertingIterableIterable<Object, O, E>(this.iterable, i -> i != null, converter));
    }

    @Override
    public IStream<T, E> distinct() {
        HashSet set = new HashSet();
        return this.filter(i -> {
            try {
                boolean bl = set.contains(i);
                return bl;
            }
            finally {
                set.add(i);
            }
        });
    }

    @Override
    public IStream<T, E> filter(IAcceptor<T> acceptor) {
        return new SequencedStream<T, E>(new FilteringIterableIterable<T, E>(this.iterable, acceptor));
    }

    @Override
    public void consum(IProcedure<T, E> procedure) throws E {
        IIterator<T, E> iterator = this.iterable.iterator();
        while (iterator.hasNext()) {
            procedure.execute(iterator.next());
        }
    }

    @Override
    public IOptional<T, E> first() throws E {
        IIterator<T, E> iterator = this.iterable.iterator();
        if (iterator.hasNext()) {
            return Optional.create(iterator.next());
        }
        return Optional.create(null);
    }

    @Override
    public IOptional<T, E> first(IAcceptor<T> acceptor) throws E {
        T next;
        IIterator<T, E> iterator = this.iterable.iterator();
        if (iterator.hasNext() && acceptor.accept(next = iterator.next())) {
            return Optional.create(next);
        }
        return Optional.create(null);
    }

    @Override
    public Iterable<T> asIterable() throws E {
        return this.asList();
    }

    @Override
    public Collection<T> asCollection() throws E {
        return this.asList();
    }

    @Override
    public List<T> asList() throws E {
        LinkedList<T> result = new LinkedList<T>();
        IIterator<T, E> iterator = this.iterable.iterator();
        while (iterator.hasNext()) {
            result.add(iterator.next());
        }
        return result;
    }

    @Override
    public IObjectList<T> asObjectList() throws E {
        return new ObjectList<T>(this.asList());
    }

    @Override
    public <O> IOptional<O, E> forAll(O identity, IAccumulator<T, O, E> adder) throws E {
        IIterator<T, E> iterator = this.iterable.iterator();
        O dummy = identity;
        while (iterator.hasNext()) {
            dummy = adder.add(dummy, iterator.next());
        }
        return Optional.create(dummy);
    }
}

