/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.resource.reference;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.MessageFormat;
import net.anwiba.commons.logging.ILevel;
import net.anwiba.commons.logging.ILogger;
import net.anwiba.commons.logging.Logging;
import net.anwiba.commons.resource.reference.FileResourceReference;
import net.anwiba.commons.resource.reference.IResourceReference;
import net.anwiba.commons.resource.reference.IResourceReferenceFactory;
import net.anwiba.commons.resource.reference.IResourceReferenceVisitor;
import net.anwiba.commons.resource.reference.MemoryResourceReference;
import net.anwiba.commons.resource.reference.ResourceReferenceFactory;
import net.anwiba.commons.resource.reference.UriResourceReference;
import net.anwiba.commons.resource.reference.UrlResourceReference;
import net.anwiba.commons.resource.utilities.FileUtilities;
import net.anwiba.commons.resource.utilities.UriToUrlConverter;
import net.anwiba.commons.resource.utilities.UriUtilities;
import net.anwiba.commons.resource.utilities.UrlToUriConverter;

public class ResourceReferenceUtilities {
    static ILogger logger = Logging.getLogger(ResourceReferenceUtilities.class.getName());
    private static IResourceReferenceFactory referenceFactory = new ResourceReferenceFactory();

    public static File getFile(IResourceReference resourceReference) throws URISyntaxException {
        if (resourceReference == null) {
            throw new IllegalArgumentException();
        }
        final UrlToUriConverter urlToUriConverter = new UrlToUriConverter();
        return resourceReference.accept(new IResourceReferenceVisitor<File, URISyntaxException>(){

            @Override
            public File visitUrlResource(UrlResourceReference urlResourceReference) throws URISyntaxException {
                return new File(urlToUriConverter.convert(urlResourceReference.getUrl()));
            }

            @Override
            public File visitUriResource(UriResourceReference uriResourceReference) {
                return new File(uriResourceReference.getUri());
            }

            @Override
            public File visitFileResource(FileResourceReference fileResourceReference) {
                return fileResourceReference.getFile();
            }

            @Override
            public File visitMemoryResource(MemoryResourceReference memoryResourceReference) {
                throw new UnsupportedOperationException();
            }
        });
    }

    public static URL getUrl(IResourceReference resourceReference) throws MalformedURLException {
        if (resourceReference == null) {
            throw new IllegalArgumentException();
        }
        final UriToUrlConverter uriToUrlConverter = new UriToUrlConverter();
        return resourceReference.accept(new IResourceReferenceVisitor<URL, MalformedURLException>(){

            @Override
            public URL visitUrlResource(UrlResourceReference urlResourceReference) {
                return urlResourceReference.getUrl();
            }

            @Override
            public URL visitUriResource(UriResourceReference uriResourceReference) throws MalformedURLException {
                return uriToUrlConverter.convert(uriResourceReference.getUri());
            }

            @Override
            public URL visitFileResource(FileResourceReference fileResourceReference) throws MalformedURLException {
                return uriToUrlConverter.convert(fileResourceReference.getFile().toURI());
            }

            @Override
            public URL visitMemoryResource(MemoryResourceReference memoryResourceReference) {
                throw new UnsupportedOperationException();
            }
        });
    }

    public static URI getUri(IResourceReference resourceReference) throws URISyntaxException {
        if (resourceReference == null) {
            throw new IllegalArgumentException();
        }
        final UrlToUriConverter urlToUriConverter = new UrlToUriConverter();
        return resourceReference.accept(new IResourceReferenceVisitor<URI, URISyntaxException>(){

            @Override
            public URI visitUrlResource(UrlResourceReference urlResourceReference) throws URISyntaxException {
                return urlToUriConverter.convert(urlResourceReference.getUrl());
            }

            @Override
            public URI visitUriResource(UriResourceReference uriResourceReference) {
                return uriResourceReference.getUri();
            }

            @Override
            public URI visitFileResource(FileResourceReference fileResourceReference) {
                return fileResourceReference.getFile().toURI();
            }

            @Override
            public URI visitMemoryResource(MemoryResourceReference memoryResourceReference) {
                throw new UnsupportedOperationException();
            }
        });
    }

    public static String getExtension(IResourceReference resourceReference) {
        if (resourceReference == null) {
            throw new IllegalArgumentException();
        }
        return resourceReference.accept(new IResourceReferenceVisitor<String, RuntimeException>(){

            @Override
            public String visitFileResource(FileResourceReference fileResourceReference) throws RuntimeException {
                return FileUtilities.getExtension(fileResourceReference.getFile());
            }

            @Override
            public String visitUrlResource(UrlResourceReference urlResourceReference) throws RuntimeException {
                String path = urlResourceReference.getUrl().getPath();
                if (path == null) {
                    return null;
                }
                return FileUtilities.getExtension(new File(path));
            }

            @Override
            public String visitUriResource(UriResourceReference uriResourceReference) throws RuntimeException {
                String path = uriResourceReference.getUri().getPath();
                if (path == null) {
                    return null;
                }
                return FileUtilities.getExtension(new File(path));
            }

            @Override
            public String visitMemoryResource(MemoryResourceReference memoryResourceReference) throws RuntimeException {
                return memoryResourceReference.getMimeType();
            }
        });
    }

    public static boolean hasLocation(IResourceReference resourceReference) {
        if (resourceReference == null) {
            return false;
        }
        return resourceReference.accept(new IResourceReferenceVisitor<Boolean, RuntimeException>(){

            @Override
            public Boolean visitUrlResource(UrlResourceReference urlResourceReference) {
                return Boolean.TRUE;
            }

            @Override
            public Boolean visitUriResource(UriResourceReference uriResourceReference) {
                return Boolean.TRUE;
            }

            @Override
            public Boolean visitFileResource(FileResourceReference fileResourceReference) {
                return Boolean.TRUE;
            }

            @Override
            public Boolean visitMemoryResource(MemoryResourceReference memoryResourceReference) {
                return Boolean.FALSE;
            }
        });
    }

    public static boolean isFileSystemResource(IResourceReference resourceReference) {
        if (resourceReference == null) {
            return false;
        }
        final UrlToUriConverter urlToUriConverter = new UrlToUriConverter();
        return resourceReference.accept(new IResourceReferenceVisitor<Boolean, RuntimeException>(){

            @Override
            public Boolean visitUriResource(UriResourceReference uriResourceReference) throws RuntimeException {
                return UriUtilities.isFileUri(uriResourceReference.getUri());
            }

            @Override
            public Boolean visitUrlResource(UrlResourceReference urlResourceReference) {
                try {
                    URI uri = urlToUriConverter.convert(urlResourceReference.getUrl());
                    return UriUtilities.isFileUri(uri);
                }
                catch (URISyntaxException exception) {
                    logger.log(ILevel.WARNING, exception.getLocalizedMessage());
                    return Boolean.FALSE;
                }
            }

            @Override
            public Boolean visitFileResource(FileResourceReference fileResourceReference) {
                return Boolean.TRUE;
            }

            @Override
            public Boolean visitMemoryResource(MemoryResourceReference memoryResourceReference) {
                return Boolean.FALSE;
            }
        });
    }

    public static String toString(IResourceReference resourceReference) {
        if (resourceReference == null) {
            throw new IllegalArgumentException();
        }
        return resourceReference.accept(new IResourceReferenceVisitor<String, RuntimeException>(){

            @Override
            public String visitFileResource(FileResourceReference fileResourceReference) throws RuntimeException {
                return fileResourceReference.getFile().toString();
            }

            @Override
            public String visitUrlResource(UrlResourceReference urlResourceReference) throws RuntimeException {
                return urlResourceReference.getUrl().toString();
            }

            @Override
            public String visitUriResource(UriResourceReference uriResourceReference) throws RuntimeException {
                return uriResourceReference.getUri().toString();
            }

            @Override
            public String visitMemoryResource(MemoryResourceReference memoryResourceReference) throws RuntimeException {
                return MessageFormat.format("memory:{0}", memoryResourceReference.toString());
            }
        });
    }
}

