/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.utilities.registry;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.anwiba.commons.utilities.registry.IKeyValueRegistry;

public class KeyValueRegistry<K, V>
implements IKeyValueRegistry<K, V> {
    private final List<V> list = new ArrayList<V>();
    private final Map<K, V> map = new HashMap();

    @Override
    public synchronized void register(K key, V value) {
        this.map.put(key, value);
        this.list.add(value);
    }

    @Override
    public synchronized V get(K key) {
        return this.map.get(key);
    }

    @Override
    public synchronized boolean contains(K key) {
        return this.map.containsKey(key);
    }

    @Override
    public synchronized V[] getItems(Comparator<K> comparator, Class<K> keyClazz, Class<V> valueClazz) {
        Object[] keys = this.map.keySet().toArray((Object[])Array.newInstance(keyClazz, this.list.size()));
        Object[] values = (Object[])Array.newInstance(valueClazz, this.list.size());
        Arrays.sort(keys, comparator);
        int i = 0;
        while (i < keys.length) {
            values[i] = this.map.get(keys[i]);
            ++i;
        }
        return values;
    }

    @Override
    public synchronized void remove(K key) {
        V value = this.map.remove(key);
        if (value == null) {
            return;
        }
        this.list.remove(value);
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.map.isEmpty();
    }
}

