/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.utilities.string;

import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.anwiba.commons.lang.object.ObjectUtilities;
import net.anwiba.commons.utilities.string.IStringPart;
import net.anwiba.commons.utilities.string.StringAppender;
import net.anwiba.commons.utilities.string.StringPart;

public class StringUtilities {
    public static boolean isNumericValue(String text) {
        if (StringUtilities.isNullOrTrimmedEmpty(text)) {
            return false;
        }
        Locale local = Locale.getDefault();
        if (StringUtilities.isNumericValue(text, local)) {
            return true;
        }
        return StringUtilities.isNumericValue(text, Locale.US);
    }

    public static boolean isNumericValue(String text, Locale local) {
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(local);
        char groupingSeparator = decimalFormatSymbols.getGroupingSeparator();
        char decimalSeparator = decimalFormatSymbols.getDecimalSeparator();
        String ungrouped = "[+-]?[0-9]+[" + decimalSeparator + "]?[0-9]*([eE][-+]?[0-9]+)?";
        String grouped = "[+-]?[0-9]{1,3}+(" + groupingSeparator + "[0-9]{3}+)*[" + decimalSeparator + "]?[0-9]*";
        String patternString = String.valueOf(ungrouped) + "|" + grouped;
        Pattern p = Pattern.compile(patternString);
        Matcher m = p.matcher(text.trim());
        return m.matches();
    }

    public static boolean isNullOrEmpty(String text) {
        return text == null || text.isEmpty();
    }

    public static boolean isNullOrTrimmedEmpty(String text) {
        return text == null || text.trim().isEmpty();
    }

    public static boolean trimedEquals(String org, String other) {
        return ObjectUtilities.equals(StringUtilities.getTrimed(org), StringUtilities.getTrimed(other));
    }

    private static String getTrimed(String string) {
        if (string == null) {
            return null;
        }
        return string.trim();
    }

    public static boolean trimedAndUpperCaseEquals(String org, String other) {
        return ObjectUtilities.equals(StringUtilities.getTrimedAndUpperCase(org), StringUtilities.getTrimedAndUpperCase(other));
    }

    private static String getTrimedAndUpperCase(String string) {
        if (string == null) {
            return null;
        }
        return string.trim().toUpperCase();
    }

    public static String repeatString(String string, int length) {
        if (string == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < length) {
            builder.append(string);
            ++i;
        }
        return builder.toString();
    }

    public static String createUniqueName(String prefix, String[] names) {
        return StringUtilities.createUniqueName(prefix, new HashSet<String>(Arrays.asList(names)));
    }

    public static String createUniqueName(String string, Set<String> names) {
        int counter = -1;
        boolean flag = true;
        for (String name : names) {
            if (!name.toUpperCase().matches(String.valueOf(StringUtilities.convertToRegEx(string.toUpperCase())) + "\\d*")) continue;
            if (name.toUpperCase().matches(string.toUpperCase())) {
                counter = Math.max(0, counter);
                flag = false;
                continue;
            }
            counter = Math.max(counter, Integer.valueOf(name.substring(string.length())));
        }
        return String.valueOf(string) + (flag || counter == -1 ? "" : String.valueOf(counter + 1));
    }

    public static String createConstantsName(String name) {
        return StringUtilities.convertToVariable(StringUtilities.removeWhiteSpaces(StringUtilities.removeAllControlCharacter(name))).toUpperCase();
    }

    private static String convertToVariable(String string) {
        StringBuilder builder = new StringBuilder();
        char[] charArray = string.toCharArray();
        if (Character.isDigit(charArray[0])) {
            builder.append("C");
        }
        char[] cArray = charArray;
        int n = charArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            switch (c) {
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case '-': 
                case '.': 
                case '?': 
                case '\\': 
                case '{': 
                case '}': {
                    builder.append('_');
                    break;
                }
                default: {
                    builder.append(c);
                }
            }
            ++n2;
        }
        return builder.toString();
    }

    private static String convertToRegEx(String string) {
        StringBuilder builder = new StringBuilder();
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            switch (c) {
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case '.': 
                case '?': 
                case '\\': 
                case '{': 
                case '}': {
                    builder.append('\\');
                    builder.append(c);
                    break;
                }
                default: {
                    builder.append(c);
                }
            }
            ++n2;
        }
        return builder.toString();
    }

    public static String removeEqualEnd(String path, String descriptionFile) {
        return net.anwiba.commons.resource.utilities.StringUtilities.removeEqualEnd(path, descriptionFile);
    }

    public static String getStringAfterLastChar(String s, char separatorChar) {
        return net.anwiba.commons.resource.utilities.StringUtilities.getStringAfterLastChar(s, separatorChar);
    }

    public static String getStringBeforLastChar(String s, char separatorChar) {
        return net.anwiba.commons.resource.utilities.StringUtilities.getStringBeforLastChar(s, separatorChar);
    }

    public static boolean containsIgnoreCase(String value, String ... strings) {
        String[] stringArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            if (StringUtilities.equalsIgnoreCase(value, string)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean equalsIgnoreCase(String value, String other) {
        return value == null ? other == null : value.equalsIgnoreCase(other);
    }

    public static List<IStringPart> getStringPositions(String text, String condition) {
        ArrayList<IStringPart> positions = new ArrayList<IStringPart>();
        if (StringUtilities.isNullOrEmpty(condition) || StringUtilities.isNullOrEmpty(text)) {
            return positions;
        }
        int position = 0;
        int i = 0;
        while (i < text.length()) {
            int index = i - position;
            if (text.charAt(i) == condition.charAt(index)) {
                if (index + 1 == condition.length()) {
                    positions.add(new StringPart(position, condition.length()));
                    position = i + 1;
                }
            } else {
                position = i + 1;
            }
            ++i;
        }
        return positions;
    }

    public static String removeWhiteSpaces(String string) {
        StringBuilder builder = new StringBuilder();
        boolean isEscaped = false;
        boolean isLiteral = false;
        boolean isWidthespace = false;
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (isEscaped) {
                builder.append(c);
                isEscaped = false;
                isWidthespace = false;
            } else if (isLiteral) {
                builder.append(c);
                isLiteral = c != '\"';
            } else {
                switch (c) {
                    case '\"': {
                        builder.append(c);
                        isWidthespace = false;
                        isLiteral = !isLiteral;
                        break;
                    }
                    case '\\': {
                        builder.append(c);
                        isEscaped = true;
                        isWidthespace = false;
                        break;
                    }
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': {
                        if (isWidthespace) break;
                        builder.append(' ');
                        isWidthespace = true;
                        break;
                    }
                    case '\u0000': 
                    case '\b': {
                        break;
                    }
                    default: {
                        builder.append(c);
                    }
                }
            }
            ++n2;
        }
        return builder.toString();
    }

    public static String removeAllControlCharacter(String string) {
        StringBuilder builder = new StringBuilder();
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            switch (c) {
                case '\u0000': 
                case '\b': 
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': {
                    break;
                }
                default: {
                    builder.append(c);
                }
            }
            ++n2;
        }
        return builder.toString();
    }

    public static String getEqualPrefix(String string, String other) {
        if (string == null || other == null) {
            return "";
        }
        int length = Math.min(string.length(), other.length());
        int i = 0;
        i = 0;
        while (i < length) {
            if (string.charAt(i) != other.charAt(i)) break;
            ++i;
        }
        if (i == 0) {
            return "";
        }
        return string.substring(0, i);
    }

    public static String[] tokens(String string, char seperator) {
        if (string == null) {
            return new String[0];
        }
        StringTokenizer tokenizer = new StringTokenizer(string, String.valueOf(seperator));
        ArrayList<String> tokens = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            tokens.add(tokenizer.nextToken());
        }
        return tokens.toArray(new String[tokens.size()]);
    }

    public static String[] trimedTokens(String string, char seperator) {
        if (string == null) {
            return new String[0];
        }
        StringTokenizer tokenizer = new StringTokenizer(string, String.valueOf(seperator));
        ArrayList<String> tokens = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            tokens.add(tokenizer.nextToken().trim());
        }
        return tokens.toArray(new String[tokens.size()]);
    }

    public static String setFirstTrimedCharacterToUpperCase(String string) {
        if (StringUtilities.isNullOrTrimmedEmpty(string)) {
            return null;
        }
        String trimed = string.trim();
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < trimed.length()) {
            if (i == 0) {
                builder.append(String.valueOf(trimed.charAt(i)).toUpperCase());
            } else {
                builder.append(trimed.charAt(i));
            }
            ++i;
        }
        return builder.toString();
    }

    public static String concatenatedString(String separator, Collection<String> values) {
        return StringUtilities.concat(separator, values.toArray(new String[values.size()]));
    }

    public static String concat(String separator, String[] values) {
        StringAppender builder = new StringAppender(separator);
        builder.append(values);
        return ((Object)builder).toString();
    }

    public static int numberOfMatches(String string, String pattern) {
        if (StringUtilities.isNullOrEmpty(string) || StringUtilities.isNullOrEmpty(pattern)) {
            return 0;
        }
        int stringLength = string.length();
        int patternLength = pattern.length();
        if (patternLength > stringLength) {
            return 0;
        }
        int counter = 0;
        int i = 0;
        while (i < stringLength) {
            int j = 0;
            j = 0;
            while (i + j < stringLength && j < patternLength) {
                if (string.charAt(i + j) != pattern.charAt(j)) break;
                ++j;
            }
            if (j == patternLength) {
                ++counter;
            }
            ++i;
        }
        return counter;
    }
}

