/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.lang.io;

import java.io.BufferedInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class MarkableInputStream
extends FilterInputStream {
    private final int available;

    public MarkableInputStream(InputStream in, long contentLength) {
        this(in, MarkableInputStream.available(in, contentLength), in.markSupported());
    }

    private static int available(InputStream in, long contentLength) {
        try {
            int available = in.available();
            return available <= 1 ? (contentLength < 0L || contentLength > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)contentLength) : available;
        }
        catch (IOException iOException) {
            return Integer.MAX_VALUE;
        }
    }

    public MarkableInputStream(InputStream in, int available, boolean markSupported) {
        super(markSupported ? in : new BufferedInputStream(in));
        this.available = available;
    }

    @Override
    public int available() throws IOException {
        return this.available;
    }
}

