/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import net.anwiba.commons.lang.collection.IObjectIterable;
import net.anwiba.commons.lang.collection.ObjectList;
import net.anwiba.commons.lang.optional.Optional;
import net.anwiba.commons.model.AbstractListChangedNotifier;
import net.anwiba.commons.model.IObjectListModel;
import net.anwiba.commons.utilities.ArrayUtilities;
import net.anwiba.commons.utilities.collection.IterableUtilities;
import net.anwiba.commons.utilities.interval.IntegerInterval;

public abstract class AbstractObjectListModel<T>
extends AbstractListChangedNotifier<T>
implements IObjectListModel<T> {
    private final Object semaphor = new Object();
    private final Map<T, Set<Integer>> indexByObjectMap = new HashMap<T, Set<Integer>>();
    private final List<T> objects = new ArrayList<T>();

    public AbstractObjectListModel(List<T> objects) {
        this.objects.addAll(objects);
        this.refreshIndex();
    }

    private void refreshIndex() {
        this.indexByObjectMap.clear();
        int i = 0;
        while (i < this.size()) {
            if (!this.indexByObjectMap.containsKey(this.get(i))) {
                this.indexByObjectMap.put(this.get(i), new HashSet());
            }
            this.indexByObjectMap.get(this.get(i)).add(i);
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        Object object = this.semaphor;
        synchronized (object) {
            return this.objects.size();
        }
    }

    @Override
    public void set(T ... objects) {
        this.set((Iterable<T>)Arrays.asList(objects));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set(Iterable<T> objects) {
        ArrayList<T> oldObjects = new ArrayList<T>();
        Object object = this.semaphor;
        synchronized (object) {
            oldObjects.addAll(IterableUtilities.asList(this.objects));
            this.indexByObjectMap.clear();
            this.objects.clear();
            for (T object2 : objects) {
                this.objects.add(object2);
            }
            this.refreshIndex();
        }
        this.fireObjectsChanged(oldObjects, objects);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T set(int index, T object) {
        AtomicReference<T> oldObjectReference = new AtomicReference<T>();
        Object object2 = this.semaphor;
        synchronized (object2) {
            if (index >= this.size()) {
                throw new IllegalArgumentException("index out of bounds");
            }
            oldObjectReference.set(this.objects.set(index, object));
            this.refreshIndex();
        }
        this.fireObjectsUpdated(Arrays.asList(index), Arrays.asList(oldObjectReference.get()), Arrays.asList(object));
        return (T)oldObjectReference.get();
    }

    @Override
    public synchronized void add(T ... objects) {
        this.add((Iterable<T>)Arrays.asList(objects));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Iterable<T> objects) {
        AtomicInteger oldNumberOfRows = new AtomicInteger();
        AtomicInteger newNumberOfRows = new AtomicInteger();
        Object object = this.semaphor;
        synchronized (object) {
            oldNumberOfRows.set(this.size());
            for (T object2 : objects) {
                this.objects.add(object2);
            }
            this.refreshIndex();
            newNumberOfRows.set(this.size());
        }
        this.fireObjectsAdded(new IntegerInterval(oldNumberOfRows.get(), newNumberOfRows.get() - 1), objects);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] indices(Iterable<T> objects) {
        Object object = this.semaphor;
        synchronized (object) {
            HashSet indexes = new HashSet();
            for (T object2 : objects) {
                Set<Integer> objectIndexes = this.indexByObjectMap.get(object2);
                Optional.of(objectIndexes).consume(values -> {
                    boolean bl = indexes.addAll(values);
                });
            }
            return ArrayUtilities.primitives(indexes.toArray(new Integer[indexes.size()]));
        }
    }

    @Override
    public void remove(T ... objects) {
        int[] indices = this.indices(Arrays.asList(objects));
        this.remove(indices);
    }

    @Override
    public void remove(Iterable<T> objects) {
        int[] indices = this.indices(objects);
        this.remove(indices);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(int ... indices) {
        AtomicReference indiciesOfRemovedObjectsReference = new AtomicReference();
        AtomicReference removedObjectsReference = new AtomicReference();
        Object object = this.semaphor;
        synchronized (object) {
            if (indices.length == 0) {
                return;
            }
            Arrays.sort(indices);
            ArrayList<T> removedObjects = new ArrayList<T>();
            HashSet indexSet = new HashSet();
            int i = indices.length - 1;
            while (i >= 0) {
                int index = indices[i];
                T object2 = this.get(index);
                T removedObject = this.objects.remove(index);
                if (removedObject != null) {
                    removedObjects.add(object2);
                }
                --i;
            }
            indiciesOfRemovedObjectsReference.set(indexSet);
            removedObjectsReference.set(removedObjects);
            this.refreshIndex();
        }
        this.fireObjectsRemoved((Iterable)indiciesOfRemovedObjectsReference.get(), (Iterable)removedObjectsReference.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAll() {
        AtomicInteger oldNumberOfRows = new AtomicInteger();
        AtomicReference<IObjectIterable<T>> oldObjectsReference = new AtomicReference<IObjectIterable<T>>();
        Object object = this.semaphor;
        synchronized (object) {
            oldNumberOfRows.set(this.size());
            oldObjectsReference.set(this.values());
            this.objects.clear();
            this.indexByObjectMap.clear();
        }
        this.fireObjectsRemoved(new IntegerInterval(0, oldNumberOfRows.get() - 1), (Iterable)oldObjectsReference.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final IObjectIterable<T> values() {
        Object object = this.semaphor;
        synchronized (object) {
            return new ObjectList<T>(Collections.unmodifiableList(IterableUtilities.asList(this.objects)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isEmpty() {
        Object object = this.semaphor;
        synchronized (object) {
            return this.objects.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Collection<T> get(int ... indices) {
        Object object = this.semaphor;
        synchronized (object) {
            ArrayList<T> result = new ArrayList<T>();
            int[] nArray = indices;
            int n = indices.length;
            int n2 = 0;
            while (n2 < n) {
                int index = nArray[n2];
                result.add(this.get(index));
                ++n2;
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final T get(int index) {
        Object object = this.semaphor;
        synchronized (object) {
            block4: {
                if (index != -1) break block4;
                return null;
            }
            return this.objects.get(index);
        }
    }
}

