/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.nls;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.logging.Level;
import net.anwiba.commons.logging.ILevel;
import net.anwiba.commons.logging.ILogger;
import net.anwiba.commons.logging.Logging;
import net.anwiba.commons.nls.MessagesProperties;

public abstract class NLS {
    private static ILogger logger = Logging.getLogger(NLS.class.getName());
    private static final String EXTENSION = ".properties";
    private static final Object ASSIGNED = new Object();
    private static final int MOD_EXPECTED = 9;
    private static final int MOD_MASK = 25;
    private static volatile AtomicReferenceArray<String> nlSuffixes = null;

    public static void initializeMessages(Class<?> clazz) {
        NLS.initializeMessages(clazz.getName(), clazz);
    }

    public static void initializeMessages(final String bundleName, final Class<?> clazz) {
        if (System.getSecurityManager() == null) {
            NLS.load(bundleName, clazz);
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                NLS.load(bundleName, clazz);
                return null;
            }
        });
    }

    public static String bind(String message, Object ... bindings) {
        return NLS.internalBind(message, bindings);
    }

    private static String internalBind(String message, Object ... args) {
        if (message == null) {
            return "No message available.";
        }
        if (args.length == 0) {
            return message;
        }
        return MessageFormat.format(message, args);
    }

    private static String[] buildVariants(String classRoot) {
        if (nlSuffixes == null) {
            String nl = Locale.getDefault().toString();
            ArrayList<String> result = new ArrayList<String>(4);
            while (true) {
                result.add(String.valueOf('_') + nl + EXTENSION);
                int lastSeparator = nl.lastIndexOf(95);
                if (lastSeparator == -1) break;
                nl = nl.substring(0, lastSeparator);
            }
            result.add(EXTENSION);
            nlSuffixes = new AtomicReferenceArray<String>(result.toArray(new String[result.size()]));
        }
        String pathRoot = classRoot.replace('.', '/');
        String[] variants = new String[nlSuffixes.length()];
        int i = 0;
        while (i < variants.length) {
            variants[i] = String.valueOf(pathRoot) + nlSuffixes.get(i);
            ++i;
        }
        return variants;
    }

    private static void computeMissingMessages(String bundleName, Map<Object, Object> fieldMap, Field[] fieldArray, boolean isAccessible) {
        int numFields = fieldArray.length;
        int i = 0;
        while (i < numFields) {
            Field field = fieldArray[i];
            if ((field.getModifiers() & 0x19) == 9 && fieldMap.get(field.getName()) != ASSIGNED) {
                try {
                    String value = "NLS missing message: " + field.getName() + " in: " + bundleName;
                    logger.log(ILevel.WARNING, value);
                    if (!isAccessible) {
                        field.setAccessible(true);
                    }
                    field.set(null, value);
                }
                catch (SecurityException exception) {
                    logger.log(ILevel.FATAL, "Error setting the missing message value for: " + field.getName(), exception);
                }
                catch (IllegalArgumentException exception) {
                    logger.log(ILevel.FATAL, "Error setting the missing message value for: " + field.getName(), exception);
                }
                catch (IllegalAccessException exception) {
                    logger.log(ILevel.FATAL, "Error setting the missing message value for: " + field.getName(), exception);
                }
            }
            ++i;
        }
    }

    private static void load(String bundleName, Class<?> clazz) {
        String[] variants;
        Field[] fieldArray = clazz.getDeclaredFields();
        ClassLoader loader = clazz.getClassLoader();
        boolean isAccessible = (clazz.getModifiers() & 1) != 0;
        int len = fieldArray.length;
        HashMap<Object, Object> fields = new HashMap<Object, Object>(len * 2);
        int i = 0;
        while (i < len) {
            fields.put(fieldArray[i].getName(), fieldArray[i]);
            ++i;
        }
        String[] stringArray = variants = NLS.buildVariants(bundleName);
        int n = variants.length;
        int n2 = 0;
        while (n2 < n) {
            block14: {
                InputStream input;
                String element = stringArray[n2];
                InputStream inputStream = input = loader == null ? ClassLoader.getSystemResourceAsStream(element) : loader.getResourceAsStream(element);
                if (input != null) {
                    try {
                        try {
                            MessagesProperties properties = new MessagesProperties(fields, bundleName, isAccessible, ASSIGNED);
                            properties.load(input);
                        }
                        catch (IOException e) {
                            logger.log(Level.SEVERE, "Error loading " + element, e);
                            try {
                                input.close();
                            }
                            catch (IOException iOException) {}
                            break block14;
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            input.close();
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    try {
                        input.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            ++n2;
        }
        NLS.computeMissingMessages(bundleName, fields, fieldArray, isAccessible);
    }
}

