/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.reflection;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.anwiba.commons.reflection.CreationException;
import net.anwiba.commons.reflection.DefaultReflectionValueProvider;
import net.anwiba.commons.reflection.IInjectingFactory;
import net.anwiba.commons.reflection.IInjektionAnalyserResult;
import net.anwiba.commons.reflection.IReflectionValueInjectionAnalyser;
import net.anwiba.commons.reflection.IReflectionValueProvider;
import net.anwiba.commons.reflection.IReflectionValueProviderBuilder;
import net.anwiba.commons.reflection.InjektingObjectFactory;
import net.anwiba.commons.reflection.ReflectionValueInjectionAnalyser;
import net.anwiba.commons.reflection.ReflectionValueProvider;
import net.anwiba.commons.reflection.utilities.IValueHolder;
import net.anwiba.commons.reflection.utilities.ListValueHolder;
import net.anwiba.commons.reflection.utilities.SingleValueHolder;

public class ReflectionValueProviderBuilder
implements IReflectionValueProviderBuilder {
    private final IReflectionValueInjectionAnalyser analyser = new ReflectionValueInjectionAnalyser();
    private final Map<Class, IValueHolder> services = new HashMap<Class, IValueHolder>();
    private final Map<Class, IValueHolder> results = new HashMap<Class, IValueHolder>();
    private final Map<Class, Class> links = new HashMap<Class, Class>();
    private final IReflectionValueProvider valueProvider;

    public ReflectionValueProviderBuilder() {
        this(new DefaultReflectionValueProvider());
    }

    public ReflectionValueProviderBuilder(IReflectionValueProvider valueProvider) {
        this.valueProvider = valueProvider;
    }

    <T> T get(Class<T> clazz) {
        if (this.results.containsKey(clazz)) {
            throw new IllegalArgumentException();
        }
        if (this.links.containsKey(clazz)) {
            return this.get(this.links.get(clazz));
        }
        if (!this.services.containsKey(clazz)) {
            return this.valueProvider.get(clazz);
        }
        IValueHolder valueHolder = this.services.get(clazz);
        if (!(valueHolder instanceof SingleValueHolder)) {
            throw new IllegalArgumentException();
        }
        return (T)((SingleValueHolder)valueHolder).getValue();
    }

    <T> Iterable<T> getAll(Class<T> clazz) {
        if (this.results.containsKey(clazz)) {
            throw new IllegalArgumentException();
        }
        if (this.links.containsKey(clazz)) {
            return this.getAll(this.links.get(clazz));
        }
        if (!this.services.containsKey(clazz)) {
            return this.valueProvider.getAll(clazz);
        }
        IValueHolder valueHolder = this.services.get(clazz);
        if (!(valueHolder instanceof ListValueHolder)) {
            throw new IllegalArgumentException();
        }
        List values = ((ListValueHolder)valueHolder).getValue().stream().map(o -> o).collect(Collectors.toList());
        values.addAll(this.valueProvider.getAll(clazz));
        return values;
    }

    @Override
    public <T> IReflectionValueProviderBuilder link(Class<T> clazz, Class<? extends T> link) {
        if (!(this.results.containsKey(clazz) || this.services.containsKey(clazz) || this.valueProvider.contains(clazz))) {
            throw new IllegalArgumentException();
        }
        if (this.links.containsKey(clazz)) {
            throw new IllegalArgumentException();
        }
        if (this.results.containsKey(link) || this.services.containsKey(link) || this.valueProvider.contains(link)) {
            throw new IllegalArgumentException();
        }
        if (this.links.containsKey(link)) {
            throw new IllegalArgumentException();
        }
        this.links.put(link, clazz);
        return this;
    }

    private <T> void checkSingleValue(Class<T> clazz) {
        if (this.results.containsKey(clazz) || this.services.containsKey(clazz) || this.valueProvider.contains(clazz)) {
            throw new IllegalArgumentException();
        }
        if (this.links.containsKey(clazz)) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public <T, S extends T> IReflectionValueProviderBuilder set(Class<T> clazz, S service) {
        this.checkSingleValue(clazz);
        this.services.put(clazz, new SingleValueHolder(service));
        return this;
    }

    @Override
    public <T> IReflectionValueProviderBuilder set(Class<T> clazz, Class<? extends T> serviceClass) {
        this.checkSingleValue(clazz);
        IInjektionAnalyserResult analyserResult = this.analyser.analyse(serviceClass);
        this.results.put(clazz, new SingleValueHolder(analyserResult));
        return this;
    }

    @Override
    public <T> IReflectionValueProviderBuilder set(Class<T> clazz, IInjectingFactory<T> objectFactory) {
        this.checkSingleValue(clazz);
        IInjektionAnalyserResult analyserResult = this.analyser.analyse(objectFactory);
        this.results.put(clazz, new SingleValueHolder(analyserResult));
        return this;
    }

    private <T> void checkListResult(Class<T> clazz) {
        IValueHolder valueHolder;
        if (this.links.containsKey(clazz)) {
            throw new IllegalArgumentException();
        }
        if (this.services.containsKey(clazz) && !((valueHolder = this.services.get(clazz)) instanceof ListValueHolder)) {
            throw new IllegalArgumentException();
        }
        if (!this.results.containsKey(clazz)) {
            this.results.put(clazz, new ListValueHolder());
        }
        if (!((valueHolder = this.results.get(clazz)) instanceof ListValueHolder)) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public <T> IReflectionValueProviderBuilder add(Class<T> clazz, IInjectingFactory<T> objectFactory) {
        this.checkListResult(clazz);
        IInjektionAnalyserResult analyserResult = this.analyser.analyse(objectFactory);
        ((ListValueHolder)this.results.get(clazz)).add(analyserResult);
        return this;
    }

    @Override
    public <T> IReflectionValueProviderBuilder add(Class<T> clazz, Class<? extends T> serviceClass) {
        this.checkListResult(clazz);
        IInjektionAnalyserResult analyserResult = this.analyser.analyse(serviceClass);
        ((ListValueHolder)this.results.get(clazz)).add(analyserResult);
        return this;
    }

    @Override
    public <T, S extends T> IReflectionValueProviderBuilder add(Class<T> clazz, S service) {
        IValueHolder valueHolder;
        if (this.results.containsKey(clazz) && !((valueHolder = this.results.get(clazz)) instanceof ListValueHolder)) {
            throw new IllegalArgumentException();
        }
        if (!this.services.containsKey(clazz)) {
            this.services.put(clazz, new ListValueHolder());
        }
        if (!((valueHolder = this.services.get(clazz)) instanceof ListValueHolder)) {
            throw new IllegalArgumentException();
        }
        ((ListValueHolder)this.services.get(clazz)).add(service);
        return this;
    }

    private boolean isResolveable(IInjektionAnalyserResult analyserResult) {
        if (analyserResult.isIndependent()) {
            return true;
        }
        for (Class type : analyserResult.getTypes()) {
            if (!this.services.containsKey(type) && !this.valueProvider.contains(type)) {
                if (this.results.containsKey(type)) {
                    return false;
                }
                if (analyserResult.isNullable(type)) continue;
                throw new IllegalStateException("Missing type '" + type + "' for object '" + analyserResult.getType() + "'");
            }
            if (!this.results.containsKey(type)) continue;
            if (analyserResult.isIterable(type)) {
                return false;
            }
            throw new IllegalStateException("Found listvalue of type '" + type + "' for singlevalue member of object '" + analyserResult.getType() + "'");
        }
        return true;
    }

    @Override
    public IReflectionValueProvider build() throws CreationException {
        InjektingObjectFactory factory = InjektingObjectFactory.create(this.valueProvider, this.services, this.links);
        int numberOfResults = 0;
        while (!this.results.isEmpty() && numberOfResults != this.results.size()) {
            HashSet<Class> keySet = new HashSet<Class>(this.results.keySet());
            numberOfResults = this.results.size();
            for (Class clazz : keySet) {
                IValueHolder valueHolder = this.results.get(clazz);
                if (valueHolder instanceof SingleValueHolder) {
                    IInjektionAnalyserResult result = (IInjektionAnalyserResult)((SingleValueHolder)valueHolder).getValue();
                    if (!this.isResolveable(result)) continue;
                    Object object = factory.create(result);
                    this.services.put(clazz, new SingleValueHolder(object));
                    this.results.remove(clazz);
                    continue;
                }
                if (!(valueHolder instanceof ListValueHolder)) continue;
                List<Object> analyserResults = ((ListValueHolder)valueHolder).getValue();
                if (!this.services.containsKey(clazz)) {
                    this.services.put(clazz, new ListValueHolder());
                }
                for (Object resultObject : analyserResults) {
                    IInjektionAnalyserResult result = (IInjektionAnalyserResult)resultObject;
                    if (!this.isResolveable(result)) continue;
                    Object object = factory.create(result);
                    ((ListValueHolder)this.services.get(clazz)).add(object);
                    ((ListValueHolder)valueHolder).remove(result);
                    if (!((ListValueHolder)valueHolder).isEmty()) continue;
                    this.results.remove(clazz);
                }
            }
        }
        if (!this.results.isEmpty()) {
            Optional<String> classes = this.results.keySet().stream().filter(v -> v != null).map(v -> v.getName()).sorted().reduce((i, v) -> i == null ? v : String.valueOf(i) + ", " + v);
            throw new CreationException("Couldn't create objects for '" + classes + "'");
        }
        return new ReflectionValueProvider(this.valueProvider, new HashMap<Class, IValueHolder>(this.services), new HashMap<Class, Class>(this.links));
    }
}

