/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.resource.utilities;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.CharBuffer;
import net.anwiba.commons.logging.ILevel;
import net.anwiba.commons.logging.ILogger;
import net.anwiba.commons.logging.Logging;

public class IoUtilities {
    private static final int BUFFER_SIZE = 4096;
    private static ILogger logger = Logging.getLogger(IoUtilities.class.getName());

    public static ByteArrayInputStream copy(InputStream inputStream) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        IoUtilities.pipe(inputStream, outputStream);
        return new ByteArrayInputStream(outputStream.toByteArray());
    }

    public static void pipe(InputStream in, OutputStream out) throws IOException {
        IoUtilities.pipe(in, out, 4096);
    }

    public static void pipe(InputStream in, OutputStream out, int bufferSize) throws IOException {
        IoUtilities.pipe(in, out, bufferSize, -1L);
    }

    public static void pipe(InputStream in, OutputStream out, int bufferSize, long numberOfBytes) throws IOException {
        int numChars;
        int arraysize = numberOfBytes > -1L && (long)bufferSize > numberOfBytes ? (int)numberOfBytes : bufferSize;
        byte[] buffer = new byte[arraysize];
        long readed = 0L;
        while ((numChars = in.read(buffer)) > 0) {
            out.write(buffer, 0, numChars);
            if (numberOfBytes <= -1L || (readed += (long)numChars) + (long)bufferSize <= numberOfBytes) continue;
            buffer = new byte[(int)(numberOfBytes - readed)];
        }
    }

    public static void pipe(Readable reader, Writer writer) throws IOException {
        IoUtilities.pipe(reader, writer, 4096);
    }

    public static void pipe(Readable in, Writer out, int bufferSize) throws IOException {
        CharBuffer buffer = CharBuffer.allocate(bufferSize);
        while (in.read(buffer) > 0) {
            buffer.flip();
            while (buffer.hasRemaining()) {
                char c = buffer.get();
                out.append(c);
            }
            out.flush();
            buffer.clear();
        }
    }

    public static void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException exception) {
                logger.log(ILevel.DEBUG, exception.getMessage(), exception);
            }
        }
    }

    public static void toss(IOException exception) throws IOException {
        if (exception != null) {
            throw exception;
        }
    }

    public static IOException close(Closeable closeable, IOException exception) {
        if (closeable == null) {
            return exception;
        }
        try {
            closeable.close();
            return exception;
        }
        catch (IOException ioException) {
            if (exception == null) {
                return ioException;
            }
            exception.addSuppressed(ioException);
            return exception;
        }
    }

    public static String toString(InputStream inputStream, String contentEncoding, long numberOfBytes) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IoUtilities.pipe(inputStream, out, 4096, numberOfBytes);
        return out.toString(contentEncoding);
    }

    public static String toString(InputStream inputStream, String contentEncoding) throws IOException {
        return IoUtilities.toString(inputStream, contentEncoding, -1L);
    }

    public static byte[] toByteArray(InputStream inputStream) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IoUtilities.pipe(inputStream, out, 4096, -1L);
        return out.toByteArray();
    }

    public static int maximumLimitOfBytes(long contentLength) {
        if (contentLength > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return IoUtilities.maximumLimitOfBytes((int)contentLength);
    }

    public static int maximumLimitOfBytes(int contentLength) {
        if (contentLength < 0) {
            return Integer.MAX_VALUE;
        }
        return contentLength + 1;
    }

    public static String toString(Reader reader) throws IOException {
        StringWriter writer = new StringWriter();
        IoUtilities.pipe(reader, writer);
        return writer.toString();
    }

    public static void pipe(InputStream inputStream, File file) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileOutputStream outputStream = new FileOutputStream(file);){
            IoUtilities.pipe(inputStream, outputStream);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

