/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.thread.process;

import java.util.ArrayList;
import java.util.List;
import net.anwiba.commons.message.IMessage;
import net.anwiba.commons.thread.process.IProcessIdentfier;
import net.anwiba.commons.thread.process.IProcessMonitor;
import net.anwiba.commons.thread.process.IProcessMonitorListener;

public class ProcessMonitor
implements IProcessMonitor {
    private final List<IProcessMonitorListener> processMonitorListeners = new ArrayList<IProcessMonitorListener>();
    private final String processDescription;
    private final IProcessIdentfier processIdentfier;

    public ProcessMonitor(IProcessIdentfier processIdentfier, String processDescription) {
        this.processIdentfier = processIdentfier;
        this.processDescription = processDescription;
    }

    @Override
    public void setNote(String note) {
        this.fireNoteChanged(note);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeProcessMonitorListener(IProcessMonitorListener listener) {
        List<IProcessMonitorListener> list = this.processMonitorListeners;
        synchronized (list) {
            this.processMonitorListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addProcessMonitorListener(IProcessMonitorListener listener) {
        List<IProcessMonitorListener> list = this.processMonitorListeners;
        synchronized (list) {
            this.processMonitorListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireNoteChanged(String note) {
        ArrayList<IProcessMonitorListener> listeners = new ArrayList<IProcessMonitorListener>();
        List<IProcessMonitorListener> list = this.processMonitorListeners;
        synchronized (list) {
            listeners.addAll(this.processMonitorListeners);
        }
        for (IProcessMonitorListener listener : listeners) {
            listener.processNoteChanged(this.processIdentfier, this.processDescription, note);
        }
    }

    @Override
    public void addMessage(IMessage message) {
        this.fireMessageAdded(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireMessageAdded(IMessage message) {
        ArrayList<IProcessMonitorListener> listeners = new ArrayList<IProcessMonitorListener>();
        List<IProcessMonitorListener> list = this.processMonitorListeners;
        synchronized (list) {
            listeners.addAll(this.processMonitorListeners);
        }
        for (IProcessMonitorListener listener : listeners) {
            listener.processMessageAdded(this.processIdentfier, this.processDescription, message);
        }
    }
}

