/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.thread.process;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.anwiba.commons.logging.ILevel;
import net.anwiba.commons.logging.ILogger;
import net.anwiba.commons.logging.Logging;
import net.anwiba.commons.message.Message;
import net.anwiba.commons.message.MessageType;
import net.anwiba.commons.thread.cancel.ICanceler;
import net.anwiba.commons.thread.cancel.ICancelerListener;
import net.anwiba.commons.thread.cancel.ICancelerProvider;
import net.anwiba.commons.thread.process.IProcess;
import net.anwiba.commons.thread.process.IProcessIdentfier;
import net.anwiba.commons.thread.process.IProcessList;
import net.anwiba.commons.thread.process.IProcessMonitor;
import net.anwiba.commons.thread.process.ProcessContext;
import net.anwiba.commons.thread.queue.IRunnable;

public final class ProcessRunner
implements IRunnable {
    private static final ILogger logger = Logging.getLogger(ProcessRunner.class.getName());
    private final IProcessList processes;
    private final IProcess process;
    private final IProcessMonitor monitor;
    private final IProcessIdentfier processIdentfier;
    private final ICancelerProvider cancelerProvider;
    private final List<ICancelerListener> listeners = new ArrayList<ICancelerListener>();
    private ICanceler canceler;

    public ProcessRunner(IProcessMonitor monitor, ICancelerProvider cancelerProvider, IProcessList processes, IProcessIdentfier processIdentfier, IProcess process) {
        this.cancelerProvider = cancelerProvider;
        this.processes = processes;
        this.processIdentfier = processIdentfier;
        this.process = process;
        this.monitor = monitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block36: {
            try {
                Object object = this.listeners;
                synchronized (object) {
                    this.canceler = this.cancelerProvider.get();
                    this.listeners.forEach(l -> this.canceler.addCancelerListener((ICancelerListener)l));
                }
                object = this.processes;
                synchronized (object) {
                    this.processes.started(new ProcessContext(this.processIdentfier, this.process.getDescription(), this.process.getQueueName(), this.monitor, this.canceler));
                }
                logger.log(ILevel.DEBUG, MessageFormat.format("process {0} started", this.processIdentfier));
                this.process.execute(this.monitor, this.canceler, this.processIdentfier);
                logger.log(ILevel.DEBUG, MessageFormat.format("process {0} finished", this.processIdentfier));
            }
            catch (InterruptedException interruptedException) {
                logger.log(ILevel.DEBUG, MessageFormat.format("process {0} interrupted", this.processIdentfier));
                Object object = this.listeners;
                synchronized (object) {
                    this.listeners.forEach(l -> this.canceler.removeCancelerListener((ICancelerListener)l));
                    this.canceler = null;
                }
                object = this.processes;
                synchronized (object) {
                    this.processes.finished(this.processIdentfier);
                    break block36;
                }
            }
            catch (RuntimeException throwable) {
                Object object;
                try {
                    this.monitor.addMessage(new Message(this.process.getDescription(), throwable.getLocalizedMessage(), throwable, MessageType.ERROR));
                    logger.log(ILevel.ERROR, "", throwable);
                    object = this.listeners;
                }
                catch (Throwable throwable2) {
                    Object object2 = this.listeners;
                    synchronized (object2) {
                        this.listeners.forEach(l -> this.canceler.removeCancelerListener((ICancelerListener)l));
                        this.canceler = null;
                    }
                    object2 = this.processes;
                    synchronized (object2) {
                        this.processes.finished(this.processIdentfier);
                    }
                    throw throwable2;
                }
                synchronized (object) {
                    this.listeners.forEach(l -> this.canceler.removeCancelerListener((ICancelerListener)l));
                    this.canceler = null;
                }
                object = this.processes;
                synchronized (object) {
                    this.processes.finished(this.processIdentfier);
                    break block36;
                }
            }
            Object object = this.listeners;
            synchronized (object) {
                this.listeners.forEach(l -> this.canceler.removeCancelerListener((ICancelerListener)l));
                this.canceler = null;
            }
            object = this.processes;
            synchronized (object) {
                this.processes.finished(this.processIdentfier);
            }
        }
    }

    @Override
    public long getDelay(TimeUnit unit) {
        return this.process.getDelay(unit);
    }

    @Override
    public boolean isPeriodic() {
        return this.process.isPeriodic();
    }

    @Override
    public boolean isCancelled() {
        if (this.canceler == null) {
            return false;
        }
        return this.canceler.isCanceled();
    }

    public String toString() {
        return MessageFormat.format("Process {0}", this.processIdentfier);
    }

    @Override
    public IProcessIdentfier getIdentifier() {
        return this.processIdentfier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addCancelerListener(ICancelerListener listener) {
        List<ICancelerListener> list = this.listeners;
        synchronized (list) {
            if (this.canceler != null) {
                this.canceler.addCancelerListener(listener);
            }
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeCancelerListener(ICancelerListener listener) {
        List<ICancelerListener> list = this.listeners;
        synchronized (list) {
            if (this.canceler != null) {
                this.canceler.removeCancelerListener(listener);
            }
            this.listeners.remove(listener);
        }
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (this.canceler == null) {
            return true;
        }
        if (this.canceler.isEnabled() && mayInterruptIfRunning) {
            this.canceler.cancel();
        }
        return this.canceler.isCanceled();
    }
}

