/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.utilities.io.url.parser;

import java.util.LinkedList;
import java.util.List;
import net.anwiba.commons.lang.optional.Optional;
import net.anwiba.commons.utilities.parameter.IParameter;
import net.anwiba.commons.utilities.parameter.Parameter;

class QueryBuilder {
    private final List<IParameter> parameters = new LinkedList<IParameter>();
    private ParameterBuilder parameterBuilder;

    QueryBuilder() {
    }

    public List<IParameter> build() {
        Optional.of(this.parameterBuilder).convert(b -> b.build()).consume(p -> {
            boolean bl = this.parameters.add((IParameter)p);
        });
        return this.parameters;
    }

    public void add(char character) {
        if (character == '&') {
            Optional.of(this.parameterBuilder).convert(b -> b.build()).consume(p -> {
                boolean bl = this.parameters.add((IParameter)p);
            });
            this.parameterBuilder = null;
            return;
        }
        if (this.parameterBuilder == null) {
            this.parameterBuilder = new ParameterBuilder();
        }
        this.parameterBuilder.add(character);
    }

    class ParameterBuilder {
        private StringBuilder builder = null;
        private State state = State.NAME;
        private String name = null;

        ParameterBuilder() {
        }

        public IParameter build() {
            switch (this.state) {
                case NAME: {
                    if (this.builder == null) {
                        return null;
                    }
                    return new Parameter(this.builder.toString(), null);
                }
                case VALUE: {
                    if (this.builder == null) {
                        return new Parameter(this.name, null);
                    }
                    return new Parameter(this.name, this.builder.toString());
                }
            }
            return null;
        }

        public void add(char character) {
            switch (this.state) {
                case NAME: {
                    if (character == '=') {
                        this.name = Optional.of(this.builder).convert(b -> b.toString()).get();
                        this.state = State.VALUE;
                        this.builder = null;
                        return;
                    }
                    if (this.builder == null) {
                        this.builder = new StringBuilder();
                    }
                    this.builder.append(character);
                    return;
                }
                case VALUE: {
                    if (this.builder == null) {
                        this.builder = new StringBuilder();
                    }
                    this.builder.append(character);
                    return;
                }
            }
        }
    }

    private static enum State {
        NAME,
        VALUE;

    }
}

