/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.ensure;

import java.text.MessageFormat;
import java.util.Objects;
import net.anwiba.commons.ensure.AbstractCondition;

public class BetweenCondition<T extends Comparable<T>>
extends AbstractCondition<T> {
    private final Comparable<T> minimum;
    private final Comparable<T> maximum;

    public BetweenCondition(Comparable<T> minimum, Comparable<T> maximum) {
        this.minimum = minimum;
        this.maximum = maximum;
    }

    @Override
    public boolean accept(T value) {
        return this.minimum.compareTo(value) <= 0 && this.maximum.compareTo(value) >= 0;
    }

    @Override
    public String toText() {
        return MessageFormat.format("is between {0} and {1}", Objects.toString(this.minimum), Objects.toString(this.maximum));
    }
}

