/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.lang.counter;

import net.anwiba.commons.lang.counter.ICounter;

public class Counter
implements ICounter {
    private long value;
    private final long maxValue;
    private final long startValue;

    public Counter(long value) {
        this(value, Long.MAX_VALUE);
    }

    public Counter(long startValue, long maxValue) {
        this.value = startValue;
        this.startValue = startValue;
        this.maxValue = maxValue;
    }

    @Override
    public synchronized long value() {
        return this.value;
    }

    @Override
    public synchronized long next() {
        if (this.value < this.maxValue) {
            return ++this.value;
        }
        this.value = this.startValue;
        return this.value;
    }

    @Override
    public void increment() {
        this.next();
    }

    @Override
    public void decrement() {
        this.previous();
    }

    @Override
    public synchronized long previous() {
        if (this.value > this.startValue) {
            return --this.value;
        }
        this.value = this.maxValue;
        return this.value;
    }

    public synchronized void add(int value) {
        this.value += (long)value;
    }

    public synchronized long minimum() {
        this.value = this.startValue;
        return this.value;
    }

    public synchronized long maximum() {
        this.value = this.maxValue;
        return this.value;
    }

    @Override
    public void set(long value) {
        this.value = value;
    }

    @Override
    public void add(long value) {
        this.value += value;
    }
}

