/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.lang.functional;

import java.util.NoSuchElementException;
import net.anwiba.commons.lang.counter.IntCounter;
import net.anwiba.commons.lang.functional.IAcceptor;
import net.anwiba.commons.lang.functional.IAggregator;
import net.anwiba.commons.lang.functional.IAssimilator;
import net.anwiba.commons.lang.functional.IConsumer;
import net.anwiba.commons.lang.functional.IIterator;

public interface IIterable<O, E extends Exception> {
    public IIterator<O, E> iterator();

    default public IIterable<O, E> iterable(final IAcceptor<O> acceptor) {
        return new IIterable<O, E>(){

            @Override
            public IIterator<O, E> iterator() {
                return this.iterator(acceptor);
            }
        };
    }

    default public IIterator<O, E> iterator(final IAcceptor<O> acceptor) {
        return new IIterator<O, E>(){
            private final IIterator<O, E> iterator;
            private O item;
            {
                this.iterator = IIterable.this.iterator();
                this.item = null;
            }

            @Override
            public boolean hasNext() throws Exception {
                while (this.iterator.hasNext()) {
                    Object i = this.iterator.next();
                    if (!acceptor.accept(i) || (this.item = i) == null) continue;
                    return true;
                }
                return false;
            }

            @Override
            public O next() throws Exception {
                try {
                    if (this.item != null || this.hasNext()) {
                        Object o = this.item;
                        return o;
                    }
                    throw new NoSuchElementException();
                }
                finally {
                    this.item = null;
                }
            }
        };
    }

    default public O first(IAcceptor<O> acceptor) throws E {
        IIterator<O, E> iterator = this.iterator();
        while (iterator.hasNext()) {
            O value = iterator.next();
            if (!acceptor.accept(value)) continue;
            return value;
        }
        return null;
    }

    default public void foreach(IConsumer<O, E> consumer) throws E {
        IIterator<O, E> iterator = this.iterator();
        while (iterator.hasNext()) {
            O value = iterator.next();
            consumer.consume(value);
        }
    }

    default public void foreach(IAssimilator<Integer, O, E> assimilator) throws E {
        IIterator<O, E> iterator = this.iterator();
        IntCounter counter = new IntCounter(-1);
        while (iterator.hasNext()) {
            O value = iterator.next();
            assimilator.assimilate(counter.next(), value);
        }
    }

    default public <R> R aggregate(R identity, IAggregator<R, O, R, E> adder) throws E {
        IIterator<O, E> iterator = this.iterator();
        R result = identity;
        while (iterator.hasNext()) {
            result = adder.aggregate(result, iterator.next());
        }
        return result;
    }
}

