/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.lang.stream;

import java.util.NoSuchElementException;
import net.anwiba.commons.lang.counter.IntCounter;
import net.anwiba.commons.lang.functional.IAcceptor;
import net.anwiba.commons.lang.functional.IAggregator;
import net.anwiba.commons.lang.functional.IIterator;

public class IteratorCountingIterator<I, O, E extends Exception>
implements IIterator<O, E> {
    private final IntCounter counter = new IntCounter(-1);
    private final IIterator<I, E> iterator;
    private final IAcceptor<I> acceptor;
    private final IAggregator<Integer, I, O, E> aggegator;
    private O item = null;

    public IteratorCountingIterator(IIterator<I, E> input, IAcceptor<I> acceptor, IAggregator<Integer, I, O, E> aggegator) {
        this.iterator = input;
        this.acceptor = acceptor;
        this.aggegator = aggegator;
    }

    @Override
    public boolean hasNext() throws E {
        while (this.iterator.hasNext()) {
            I i = this.iterator.next();
            if (!this.acceptor.accept(i) || (this.item = this.aggegator.aggregate(this.counter.next(), (Integer)i)) == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public O next() throws E {
        try {
            if (this.item != null || this.hasNext()) {
                O o = this.item;
                return o;
            }
            throw new NoSuchElementException();
        }
        finally {
            this.item = null;
        }
    }
}

