/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.logging;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.SimpleFormatter;
import java.util.logging.StreamHandler;
import net.anwiba.commons.logging.ILevel;
import net.anwiba.commons.logging.ILogger;
import net.anwiba.commons.logging.Logging;
import net.anwiba.commons.logging.java.JavaLogging;
import org.apache.log4j.LogManager;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.xml.DOMConfigurator;

public class LoggingUtilities {
    private static final String CONSOLE = "console";
    private static final String DEFAULT_XML_LOG_CONFIGURATION_FILE = "log4j.xml";
    private static final String DEFAULT_PROPERTIES_LOG_CONFIGURATION_FILE = "log.properties";
    private static final String NET_ANWIBA_LOGGING_CONFIGURATION = "net.anwiba.logging.configuration";
    private static final String CONSOLE_HANDLER = "console";
    private static final String NET_ANWIBA = "net.anwiba";
    private static final String FILE = "file";
    private static final String FILE_HANDLER = "FILE";
    private static final String HANDLER = "handler";
    private static final String LEVEL = "level";

    public static void initialize() {
        String loggingConfigurationFileName = LoggingUtilities.getLoggingConfigurationFileName();
        LoggingUtilities.initialize(loggingConfigurationFileName);
    }

    private static String getLoggingConfigurationFileName() {
        String loggingConfigurationFileName = System.getProperty(NET_ANWIBA_LOGGING_CONFIGURATION);
        if (loggingConfigurationFileName != null && new File(loggingConfigurationFileName).exists()) {
            return loggingConfigurationFileName;
        }
        File xmlFile = LoggingUtilities.getFile(DEFAULT_XML_LOG_CONFIGURATION_FILE);
        if (xmlFile.exists()) {
            return xmlFile.getAbsolutePath();
        }
        File propertiesFile = LoggingUtilities.getFile(DEFAULT_PROPERTIES_LOG_CONFIGURATION_FILE);
        if (propertiesFile.exists()) {
            return propertiesFile.getAbsolutePath();
        }
        return null;
    }

    public static File getFile(String name) {
        String pathName;
        File path;
        String classpath = System.getProperty("java.class.path");
        StringTokenizer tokenizer = new StringTokenizer(classpath, File.pathSeparator);
        if (tokenizer.hasMoreTokens() && new File((path = new File(pathName = tokenizer.nextToken())).getParentFile(), name).exists()) {
            return new File(path.getParentFile(), name);
        }
        return new File(new File(System.getProperty("user.dir")), name);
    }

    public static void initialize(InputStream inputStream) {
        try {
            new DOMConfigurator().doConfigure(inputStream, LogManager.getLoggerRepository());
            ILogger logger = Logging.getLogger(LoggingUtilities.class.getName());
            logger.log(ILevel.DEBUG, "initialized logging by inputstream");
        }
        catch (SecurityException exception) {
            exception.printStackTrace();
        }
    }

    public static void initialize(String loggingConfigurationFileName) {
        try {
            boolean log4jAvailable = LoggingUtilities.isLog4JAvailable();
            if (!log4jAvailable) {
                LoggingUtilities.initializeJavaLogging(loggingConfigurationFileName);
                return;
            }
            if (loggingConfigurationFileName == null || loggingConfigurationFileName.trim().isEmpty()) {
                Properties properties = LoggingUtilities.createDefaultLogging("INFO", LoggingUtilities.create("console", FILE), new String[0]);
                PropertyConfigurator.configure((Properties)properties);
                return;
            }
            if (loggingConfigurationFileName.trim().toLowerCase().endsWith(".xml")) {
                DOMConfigurator.configure((String)loggingConfigurationFileName);
                ILogger logger = Logging.getLogger(LoggingUtilities.class.getName());
                logger.log(ILevel.DEBUG, "initialized logging by file " + loggingConfigurationFileName);
                return;
            }
            Properties properties = LoggingUtilities.loadProperties(loggingConfigurationFileName);
            properties = properties.isEmpty() ? LoggingUtilities.createDefaultLogging("INFO", LoggingUtilities.create("console", FILE), new String[0]) : properties;
            PropertyConfigurator.configure((Properties)properties);
            ILogger logger = Logging.getLogger(LoggingUtilities.class.getName());
            logger.log(ILevel.DEBUG, "initialized logging by file " + loggingConfigurationFileName);
            logger.log(ILevel.DEBUG, MessageFormat.format("for file {0}", properties.getProperty("log4j.appender.file.File", "none")));
        }
        catch (SecurityException exception) {
            exception.printStackTrace();
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
    }

    private static Set<String> create(String ... values) {
        return new HashSet<String>(Arrays.asList(values));
    }

    private static boolean isLog4JAvailable() {
        try {
            Class.forName("org.apache.log4j.Logger");
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static void initalize(String level, String ... namespaces) {
        Properties properties = LoggingUtilities.createDefaultLogging(level, LoggingUtilities.create("console"), namespaces);
        PropertyConfigurator.configure((Properties)properties);
    }

    private static Properties createDefaultLogging(String level, Set<String> appenders, String ... namespaces) {
        Properties properties = new Properties();
        String[] stringArray = namespaces;
        int n = namespaces.length;
        int n2 = 0;
        while (n2 < n) {
            String namespace = stringArray[n2];
            properties.put("log4j.logger." + namespace, level);
            ++n2;
        }
        if (appenders.contains("console")) {
            properties.put("log4j.logger.net.anwiba", level);
            properties.put("log4j.appender.SYSTEM_OUT", "org.apache.log4j.ConsoleAppender");
            properties.put("log4j.appender.SYSTEM_OUT.layout", "org.apache.log4j.PatternLayout");
            properties.put("log4j.appender.SYSTEM_OUT.layout.ConversionPattern", "%d{ISO8601} %-5p [%t] %-25.25c - %m%n");
            properties.put("log4j.rootLogger", MessageFormat.format("{0}, SYSTEM_OUT, FILE", level));
        }
        if (appenders.contains(FILE)) {
            properties.put("log4j.appender.file", "org.apache.log4j.RollingFileAppender");
            properties.put("log4j.appender.file.File", LoggingUtilities.getLogFileName(null));
            properties.put("log4j.appender.file.DatePattern", "'_'yyyy-MM-dd'.log'");
            properties.put("log4j.appender.file.layout", "org.apache.log4j.PatternLayout");
            properties.put("log4j.appender.file.layout.ConversionPattern", "[%p] [%d{dd.MM.yyyy-HH:mm:ss}] %m%n");
        }
        return properties;
    }

    public static void initializeJavaLogging(String propertiesFileName) {
        try {
            if (propertiesFileName == null || propertiesFileName.trim().isEmpty()) {
                return;
            }
            Properties properties = LoggingUtilities.loadProperties(propertiesFileName);
            SimpleFormatter formatter = new SimpleFormatter();
            Handler[] handlers = LoggingUtilities.createHandler(properties, formatter);
            String levelName = (String)properties.get(LEVEL);
            LoggingUtilities.initializeLogger(levelName == null ? JavaLogging.create(ILevel.DEBUG) : Level.parse(levelName), handlers);
            ILogger logger = Logging.getLogger(LoggingUtilities.class.getName());
            logger.log(ILevel.DEBUG, "initialized logging by file " + propertiesFileName);
            logger.log(ILevel.DEBUG, "for file " + properties.getProperty("log4j.appender.file.File", "none"));
            logger.log(ILevel.DEBUG, "initialized logging level " + levelName);
        }
        catch (SecurityException exception) {
            exception.printStackTrace();
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
    }

    private static Handler[] createDefaultHandler(Formatter formatter) throws IOException {
        FileHandler fileHandler = new FileHandler(LoggingUtilities.getLogFileName(null), false);
        fileHandler.setFormatter(formatter);
        return new Handler[]{fileHandler};
    }

    private static Properties loadProperties(String propertiesFileName) throws IOException, FileNotFoundException {
        Properties properties = new Properties();
        File propertiesFile = new File(propertiesFileName);
        if (!propertiesFile.exists()) {
            return properties;
        }
        Throwable throwable = null;
        Object var4_5 = null;
        try (FileReader reader = new FileReader(propertiesFile);){
            properties.load(reader);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return properties;
    }

    private static void initializeLogger(Level level, Handler ... handlers) {
        Logging.setHandler(handlers);
        Logging.setLevel(level, NET_ANWIBA);
    }

    private static Handler[] createHandler(Properties properties, Formatter formatter) throws SecurityException, IOException {
        String handlerList = (String)properties.get(HANDLER);
        if (handlerList == null) {
            return LoggingUtilities.createDefaultHandler(formatter);
        }
        ArrayList<ConsoleHandler> handlers = new ArrayList<ConsoleHandler>();
        StringTokenizer tokenizer = new StringTokenizer(handlerList, ",");
        while (tokenizer.hasMoreElements()) {
            StreamHandler handler;
            String handlerType = (String)tokenizer.nextElement();
            if (handlerType.equalsIgnoreCase(FILE_HANDLER)) {
                String file = (String)properties.get(FILE);
                handler = new FileHandler(LoggingUtilities.getLogFileName(file), false);
            } else {
                if (!handlerType.equalsIgnoreCase("console")) continue;
                handler = new ConsoleHandler();
            }
            handler.setFormatter(formatter);
            handlers.add((ConsoleHandler)handler);
        }
        return handlers.toArray(new Handler[handlers.size()]);
    }

    private static String getLogFileName(String file) {
        if (file == null) {
            return String.valueOf(LoggingUtilities.getPathName()) + File.separator + "viewer.log.%u";
        }
        return file;
    }

    private static String getPathName() {
        String pathName = String.valueOf(System.getProperty("user.home")) + File.separator + ".anwiba";
        File file = new File(pathName);
        if (!file.exists() && !file.mkdirs()) {
            return System.getProperty("user.home");
        }
        return pathName;
    }
}

