/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.model;

import net.anwiba.commons.lang.functional.IEqualComperator;
import net.anwiba.commons.lang.object.ObjectUtilities;
import net.anwiba.commons.model.AbstractObjectChangedNotifier;
import net.anwiba.commons.model.IObjectModel;

public class ObjectModel<T>
extends AbstractObjectChangedNotifier
implements IObjectModel<T> {
    private final Object monitor = new Object();
    private T value;
    private final boolean isNullable;
    private IEqualComperator<T> comperator;

    public ObjectModel() {
        this(null);
    }

    public ObjectModel(IEqualComperator<T> comperator, T value) {
        this(true, comperator, value);
    }

    public ObjectModel(T value) {
        this(true, (t, o) -> ObjectUtilities.equals(t, o), value);
    }

    public ObjectModel(boolean isNullable, IEqualComperator<T> comperator, T value) {
        this.accept(isNullable, value);
        this.comperator = comperator;
        this.isNullable = isNullable;
        this.value = value;
    }

    private void accept(boolean isNullable, T value) {
        if (!isNullable && value == null) {
            throw new IllegalArgumentException("argument is null");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set(T value) {
        this.accept(this.isNullable, value);
        Object object = this.monitor;
        synchronized (object) {
            if (this.comperator.equals(this.value, value)) {
                return;
            }
            this.value = value;
        }
        this.fireObjectChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() {
        Object object = this.monitor;
        synchronized (object) {
            return this.value;
        }
    }
}

