/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.anwiba.commons.model.ISelectionListener;
import net.anwiba.commons.model.ISelectionModel;
import net.anwiba.commons.model.SelectionEvent;
import net.anwiba.commons.utilities.collection.IterableUtilities;
import net.anwiba.commons.utilities.collection.SetUtilities;

public class SelectionModel<T>
implements ISelectionModel<T> {
    private final List<ISelectionListener<T>> listeners = new ArrayList<ISelectionListener<T>>();
    private final List<T> selectedObjects = new ArrayList<T>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSelectedObject(T object) {
        boolean changed = false;
        List<T> list = this.selectedObjects;
        synchronized (list) {
            if (this.selectedObjects.size() == 1 && this.isSelected(object)) {
                return;
            }
            if (!this.selectedObjects.isEmpty()) {
                this.clear();
                changed = true;
            }
            if (object != null) {
                changed |= this.selectedObjects.add(object);
            }
        }
        if (changed) {
            this.fireSelectionChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSelectedObjects(Collection<T> objects) {
        boolean changed = false;
        List<T> list = this.selectedObjects;
        synchronized (list) {
            if (SetUtilities.equals(new HashSet<T>(this.selectedObjects), objects)) {
                return;
            }
            if (!this.selectedObjects.isEmpty()) {
                this.clear();
                changed = true;
            }
            if (!objects.isEmpty()) {
                changed |= this.selectedObjects.addAll(objects);
            }
        }
        if (changed) {
            this.fireSelectionChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSelectedObject(T object) {
        boolean changed = false;
        List<T> list = this.selectedObjects;
        synchronized (list) {
            if (object == null || this.isSelected(object)) {
                return;
            }
            changed = this.selectedObjects.add(object);
        }
        if (changed) {
            this.fireSelectionChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSelectedObjects(Collection<T> objects) {
        boolean changed = false;
        List<T> list = this.selectedObjects;
        synchronized (list) {
            if (objects == null || objects.isEmpty()) {
                return;
            }
            Set<T> diverence = SetUtilities.getContainsNot(new HashSet<T>(this.selectedObjects), objects);
            changed = this.selectedObjects.addAll(diverence);
        }
        if (changed) {
            this.fireSelectionChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSelected(T object) {
        List<T> list = this.selectedObjects;
        synchronized (list) {
            return this.selectedObjects.contains(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSelectedObject(T object) {
        boolean removed = false;
        List<T> list = this.selectedObjects;
        synchronized (list) {
            if (object == null || !this.isSelected(object)) {
                return;
            }
            removed = this.selectedObjects.remove(object);
        }
        if (removed) {
            this.fireSelectionChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSelectedObjects(Collection<T> objects) {
        boolean removed = false;
        List<T> list = this.selectedObjects;
        synchronized (list) {
            if (objects == null || objects.isEmpty()) {
                return;
            }
            removed = this.selectedObjects.removeAll(objects);
        }
        if (removed) {
            this.fireSelectionChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAllSelectedObjects() {
        List<T> list = this.selectedObjects;
        synchronized (list) {
            if (this.selectedObjects.isEmpty()) {
                return;
            }
            this.clear();
        }
        this.fireSelectionChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        List<T> list = this.selectedObjects;
        synchronized (list) {
            return this.selectedObjects.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        List<T> list = this.selectedObjects;
        synchronized (list) {
            return this.selectedObjects.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clear() {
        List<T> list = this.selectedObjects;
        synchronized (list) {
            this.selectedObjects.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSelectionListener(ISelectionListener<T> listener) {
        List<ISelectionListener<T>> list = this.listeners;
        synchronized (list) {
            if (this.listeners.contains(listener)) {
                return;
            }
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSelectionListener(ISelectionListener<T> listener) {
        List<ISelectionListener<T>> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireSelectionChanged() {
        ArrayList<ISelectionListener<T>> currentListeners;
        List<ISelectionListener<T>> list = this.listeners;
        synchronized (list) {
            currentListeners = new ArrayList<ISelectionListener<T>>(this.listeners);
        }
        for (ISelectionListener iSelectionListener : currentListeners) {
            iSelectionListener.selectionChanged(new SelectionEvent(this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterable<T> getSelectedObjects() {
        List<T> list = this.selectedObjects;
        synchronized (list) {
            return IterableUtilities.asList(this.selectedObjects);
        }
    }
}

