/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.reflection.utilities;

import java.lang.reflect.Array;
import java.util.Collection;

public class ObjectToArrayConverter {
    public static Object toPrimativArray(Collection<?> object, Class<?> componentType) {
        if (componentType.isAssignableFrom(Double.TYPE)) {
            return ObjectToArrayConverter.toDoubleArray(object);
        }
        if (componentType.isAssignableFrom(Float.TYPE)) {
            return ObjectToArrayConverter.toFloatArray(object);
        }
        if (componentType.isAssignableFrom(Long.TYPE)) {
            return ObjectToArrayConverter.toLongArray(object);
        }
        if (componentType.isAssignableFrom(Integer.TYPE)) {
            return ObjectToArrayConverter.toIntArray(object);
        }
        if (componentType.isAssignableFrom(Short.TYPE)) {
            return ObjectToArrayConverter.toShortArray(object);
        }
        if (componentType.isAssignableFrom(Boolean.TYPE)) {
            return ObjectToArrayConverter.toBooleanArray(object);
        }
        if (componentType.isAssignableFrom(Byte.TYPE)) {
            return ObjectToArrayConverter.toByteArray(object);
        }
        if (componentType.isAssignableFrom(Character.TYPE)) {
            return ObjectToArrayConverter.toCharArray(object);
        }
        throw new RuntimeException();
    }

    public static Object toArray(Collection object, Class<?> clazz) {
        if (!clazz.getComponentType().isArray()) {
            if (clazz.getComponentType().isPrimitive()) {
                return ObjectToArrayConverter.toPrimativArray(object, clazz.getComponentType());
            }
            Object array = Array.newInstance(clazz.getComponentType(), object.size());
            int index = 0;
            for (Object value : object) {
                if (!clazz.getComponentType().isInstance(object)) continue;
                Array.set(array, index, clazz.getComponentType().cast(value));
                ++index;
            }
            return array;
        }
        Object array = Array.newInstance(clazz.getComponentType(), object.size());
        int index = 0;
        for (Object values : object) {
            Object value = ObjectToArrayConverter.toArray((Collection)values, clazz.getComponentType());
            Array.set(array, index, value);
            ++index;
        }
        return array;
    }

    public static double[] toDoubleArray(Collection<?> collection) {
        double[] array = new double[collection.size()];
        Object[] objects = collection.toArray();
        int i = 0;
        while (i < array.length) {
            array[i] = ((Number)objects[i]).doubleValue();
            ++i;
        }
        return array;
    }

    private static float[] toFloatArray(Collection<?> collection) {
        float[] array = new float[collection.size()];
        Object[] objects = collection.toArray();
        int i = 0;
        while (i < array.length) {
            array[i] = ((Number)objects[i]).floatValue();
            ++i;
        }
        return array;
    }

    public static long[] toLongArray(Collection<?> collection) {
        long[] array = new long[collection.size()];
        Object[] objects = collection.toArray();
        int i = 0;
        while (i < array.length) {
            array[i] = ((Number)objects[i]).longValue();
            ++i;
        }
        return array;
    }

    public static int[] toIntArray(Collection<?> collection) {
        int[] array = new int[collection.size()];
        Object[] objects = collection.toArray();
        int i = 0;
        while (i < array.length) {
            array[i] = ((Number)objects[i]).intValue();
            ++i;
        }
        return array;
    }

    public static short[] toShortArray(Collection<?> collection) {
        short[] array = new short[collection.size()];
        Object[] objects = collection.toArray();
        int i = 0;
        while (i < array.length) {
            array[i] = ((Number)objects[i]).shortValue();
            ++i;
        }
        return array;
    }

    private static boolean[] toBooleanArray(Collection<?> collection) {
        boolean[] array = new boolean[collection.size()];
        Object[] objects = collection.toArray();
        int i = 0;
        while (i < array.length) {
            array[i] = (Boolean)objects[i];
            ++i;
        }
        return array;
    }

    public static byte[] toByteArray(Collection<?> collection) {
        byte[] array = new byte[collection.size()];
        Object[] objects = collection.toArray();
        int i = 0;
        while (i < array.length) {
            array[i] = (Byte)objects[i];
            ++i;
        }
        return array;
    }

    private static char[] toCharArray(Collection<?> collection) {
        char[] array = new char[collection.size()];
        Object[] objects = collection.toArray();
        int i = 0;
        while (i < array.length) {
            array[i] = ((Character)objects[i]).charValue();
            ++i;
        }
        return array;
    }
}

