/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.utilities.boole;

import net.anwiba.commons.utilities.boole.BooleanParser;
import net.anwiba.commons.utilities.string.StringUtilities;
import net.anwiba.commons.utilities.validation.IValidationResult;
import net.anwiba.commons.utilities.validation.IValidator;

public final class BooleanStringValidator
implements IValidator<String> {
    private final BooleanParser parser;

    public BooleanStringValidator(BooleanParser parser) {
        this.parser = parser;
    }

    @Override
    public IValidationResult validate(String value) {
        if (StringUtilities.isNullOrTrimmedEmpty(value)) {
            return IValidationResult.valid();
        }
        try {
            this.parser.parse(value);
            return IValidationResult.valid();
        }
        catch (Throwable exception) {
            return IValidationResult.inValid(exception.getLocalizedMessage());
        }
    }
}

