/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.utilities.collection;

import java.util.Collection;
import java.util.Set;
import net.anwiba.commons.lang.functional.IAcceptor;
import net.anwiba.commons.utilities.collection.IterableUtilities;

public class SetUtilities {
    public static <T> Set<T> getContainsNot(final Set<T> set, final Iterable<T> other) {
        return IterableUtilities.asSet(other, new IAcceptor<T>(){

            @Override
            public boolean accept(T value) {
                return !set.contains(other);
            }
        });
    }

    public static <T> boolean equals(Set<T> set, Collection<T> collection) {
        if (set == collection) {
            return true;
        }
        if (set == null || collection == null || set.size() != collection.size()) {
            return false;
        }
        return set.containsAll(collection);
    }
}

