/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.utilities.interval;

import java.io.Serializable;
import java.util.Arrays;
import net.anwiba.commons.lang.object.ObjectUtilities;

public class DoubleInterval
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final double minValue;
    private final double maxValue;
    private final double factor;

    public DoubleInterval(double minValue, double maxValue) {
        this.minValue = Math.min(minValue, maxValue);
        this.maxValue = Math.max(minValue, maxValue);
        this.factor = 1.0 / (this.maxValue - this.minValue);
    }

    public boolean inside(double value) {
        if (Double.isNaN(value)) {
            return false;
        }
        return value > this.minValue && this.maxValue > value;
    }

    public boolean interact(double value) {
        if (Double.isNaN(value)) {
            return false;
        }
        return value == this.minValue || value == this.maxValue || this.inside(value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DoubleInterval)) {
            return false;
        }
        DoubleInterval other = (DoubleInterval)obj;
        return Arrays.equals(new double[]{this.minValue, this.maxValue}, new double[]{other.minValue, other.maxValue});
    }

    public int hashCode() {
        return ObjectUtilities.hashCode(this.minValue, this.maxValue);
    }

    public double fraction(double value) {
        double d = this.factor * (value - this.minValue);
        return d;
    }

    public double getMaximum() {
        return this.maxValue;
    }

    public double getMinimum() {
        return this.minValue;
    }

    public String toString() {
        return Arrays.toString(new double[]{this.minValue, this.maxValue});
    }

    public double distance() {
        return Math.abs(this.getMaximum() - this.getMinimum());
    }
}

