/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.utilities.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Optional;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import net.anwiba.commons.reference.utilities.IoUtilities;

public class ZipUtilities {
    public static void extract(File resource, File targetFolder) throws IOException {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileInputStream fis = new FileInputStream(resource);){
                ZipEntry entry;
                File folder = targetFolder;
                ZipInputStream zis = new ZipInputStream(new BufferedInputStream(fis));
                while ((entry = zis.getNextEntry()) != null) {
                    File file = new File(folder, ZipUtilities.resolveSpecialPathNames(entry.getName()));
                    if (entry.isDirectory()) {
                        file.mkdir();
                        continue;
                    }
                    byte[] data = new byte[2048];
                    Throwable throwable2 = null;
                    Object var11_15 = null;
                    try (FileOutputStream fos = new FileOutputStream(file);){
                        Throwable throwable3 = null;
                        Object var14_20 = null;
                        try (BufferedOutputStream dest = new BufferedOutputStream(fos, 2048);){
                            int count;
                            while ((count = zis.read(data, 0, 2048)) != -1) {
                                dest.write(data, 0, count);
                            }
                            dest.flush();
                        }
                        catch (Throwable throwable4) {
                            if (throwable3 == null) {
                                throwable3 = throwable4;
                            } else if (throwable3 != throwable4) {
                                throwable3.addSuppressed(throwable4);
                            }
                            throw throwable3;
                        }
                    }
                    catch (Throwable throwable5) {
                        if (throwable2 == null) {
                            throwable2 = throwable5;
                        } else if (throwable2 != throwable5) {
                            throwable2.addSuppressed(throwable5);
                        }
                        throw throwable2;
                    }
                }
            }
            catch (Throwable throwable6) {
                if (throwable == null) {
                    throwable = throwable6;
                } else if (throwable != throwable6) {
                    throwable.addSuppressed(throwable6);
                }
                throw throwable;
            }
        }
        catch (IOException exception) {
            throw new IOException("extract of resource '" + resource + "' faild", exception);
        }
    }

    static String resolveSpecialPathNames(String name) throws IOException {
        Path normalize = new File(name).toPath().normalize();
        ArrayList items = new ArrayList();
        normalize.forEach(p -> Optional.of(p).filter(i -> !i.equals(Paths.get("..", new String[0]))).ifPresent(i -> {
            boolean bl = items.add(i);
        }));
        if (items.size() != normalize.getNameCount()) {
            throw new IOException("Entry is outside of the target folder '" + name + "'");
        }
        return items.stream().map(p -> p.toString()).reduce(null, (i, s) -> i == null ? s : String.valueOf(i) + File.separator + s);
    }

    public static void zipFile(File sourceFile, File destinationFile) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileOutputStream fileOutputStream = new FileOutputStream(destinationFile);){
            ZipUtilities.zipFile(sourceFile, (OutputStream)fileOutputStream);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static void zipFile(File sourceFile, OutputStream destinationOutputStream) throws IOException {
        ZipUtilities.zipFile(new File[]{sourceFile}, destinationOutputStream);
    }

    public static void zipFile(File[] sourceFiles, OutputStream destinationOutputStream) throws IOException {
        ZipOutputStream zipOutputStream = null;
        try {
            zipOutputStream = new ZipOutputStream(destinationOutputStream);
            File[] fileArray = sourceFiles;
            int n = sourceFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File sourceFile = fileArray[n2];
                if (!sourceFile.exists()) {
                    throw new IllegalArgumentException("Source file '" + sourceFile + "' does not exist.");
                }
                if (sourceFile.isFile()) {
                    ZipUtilities.addFile(zipOutputStream, sourceFile, "");
                } else {
                    ZipUtilities.addDirectory(zipOutputStream, sourceFile, "");
                }
                ++n2;
            }
            zipOutputStream.finish();
        }
        catch (Throwable throwable) {
            IoUtilities.close(zipOutputStream);
            throw throwable;
        }
        IoUtilities.close(zipOutputStream);
    }

    private static void addFile(ZipOutputStream zipOutputStream, File sourceFile, String folder) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (FileInputStream inFis = new FileInputStream(sourceFile);){
            ZipEntry zipentry = new ZipEntry(String.valueOf(folder) + sourceFile.getName());
            zipentry.setMethod(8);
            zipOutputStream.putNextEntry(zipentry);
            IoUtilities.pipe((InputStream)inFis, zipOutputStream);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static void addDirectory(ZipOutputStream zipOutputStream, File directory, String folder) throws IOException {
        File[] files;
        File[] fileArray = files = directory.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File inFile = fileArray[n2];
            if (inFile.isFile()) {
                ZipUtilities.addFile(zipOutputStream, inFile, folder);
            } else {
                ZipUtilities.addDirectory(zipOutputStream, inFile, String.valueOf(folder) + inFile.getName() + "/");
            }
            ++n2;
        }
    }
}

