/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.utilities.io.number;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;
import net.anwiba.commons.lang.counter.Counter;
import net.anwiba.commons.utilities.ByteUtilities;

public class NumberReader {
    private final byte[] array = new byte[8];
    private final Counter counter = new Counter(0L);
    private final InputStream inputStream;
    private ByteOrder byteOrder = ByteOrder.BIG_ENDIAN;

    public NumberReader(InputStream inputStream) {
        this.inputStream = new BufferedInputStream(inputStream);
    }

    public void setByteOrder(ByteOrder byteOrder) {
        this.byteOrder = byteOrder;
    }

    public byte readByte() throws IOException {
        this.read(1);
        return this.array[0];
    }

    public int readInteger() throws IOException {
        this.read(4);
        return ByteUtilities.getInteger(this.array, 0, this.byteOrder);
    }

    public double readDouble() throws IOException {
        this.read(8);
        return ByteUtilities.getDouble(this.array, 0, this.byteOrder);
    }

    public double readFloat() throws IOException {
        this.read(4);
        return ByteUtilities.getFloat(this.array, 0, this.byteOrder);
    }

    private void read(int length) throws IOException {
        int readed = this.inputStream.read(this.array, 0, length);
        if (readed < length) {
            throw new IOException("exepected " + length + " byte, but got " + readed);
        }
        this.counter.add(readed);
    }
}

