/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.utilities.io.number;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteOrder;
import net.anwiba.commons.utilities.ByteUtilities;

public class NumberWriter {
    private final byte[] array = new byte[8];
    private final OutputStream outputStream;
    private final ByteOrder byteOrder;

    public NumberWriter(OutputStream outputStream, ByteOrder byteOrder) {
        this.outputStream = outputStream;
        this.byteOrder = byteOrder;
    }

    public void writeByte(byte value) throws IOException {
        this.outputStream.write(value);
    }

    public void writeInteger(int value) throws IOException {
        ByteUtilities.setInteger(value, this.array, 0, this.byteOrder);
        this.outputStream.write(this.array, 0, 4);
    }

    public void writeDouble(double value) throws IOException {
        ByteUtilities.setDouble(value, this.array, 0, this.byteOrder);
        this.outputStream.write(this.array, 0, 8);
    }

    public void writeFloat(float value) throws IOException {
        ByteUtilities.setFloat(value, this.array, 0, this.byteOrder);
        this.outputStream.write(this.array, 0, 4);
    }
}

