/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.utilities.io.url;

import java.util.List;
import java.util.stream.Collectors;
import net.anwiba.commons.lang.optional.Optional;
import net.anwiba.commons.utilities.collection.IterableUtilities;
import net.anwiba.commons.utilities.io.url.IAuthentication;
import net.anwiba.commons.utilities.io.url.IAuthority;
import net.anwiba.commons.utilities.io.url.IHost;
import net.anwiba.commons.utilities.io.url.IUrl;
import net.anwiba.commons.utilities.parameter.IParameter;
import net.anwiba.commons.utilities.parameter.IParameters;
import net.anwiba.commons.utilities.parameter.ParametersBuilder;
import net.anwiba.commons.utilities.string.StringUtilities;

public class Url
implements IUrl {
    private final List<String> scheme;
    private final List<String> path;
    private final IParameters parameters;
    private final String fragment;
    private final IAuthority authority;

    public Url(List<String> scheme, IAuthority authority, List<String> path, List<IParameter> parameters, String fragment) {
        this.scheme = scheme;
        this.authority = authority;
        this.path = path;
        this.parameters = new ParametersBuilder().add(parameters).build();
        this.fragment = fragment;
    }

    @Override
    public List<String> getScheme() {
        return this.scheme;
    }

    @Override
    public IAuthentication getAuthentication() {
        return Optional.of(this.authority).convert(a -> a.getAuthentication()).get();
    }

    @Override
    public IHost getHost() {
        return Optional.of(this.authority).convert(a -> a.getHost()).get();
    }

    @Override
    public List<String> getPath() {
        return this.path;
    }

    @Override
    public IParameters getQuery() {
        return this.parameters;
    }

    @Override
    public String getFragment() {
        return this.fragment;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(StringUtilities.concat(":", this.scheme));
        builder.append("://");
        if (this.authority != null) {
            IHost host;
            IAuthentication authentication = this.getAuthentication();
            if (authentication != null) {
                builder.append(authentication.getUsername());
                builder.append(":");
                builder.append(authentication.getPassword());
                builder.append("@");
            }
            if ((host = this.getHost()) != null) {
                builder.append(host.getName());
                if (host.getPort() > -1) {
                    builder.append(":");
                    builder.append(host.getPort());
                }
            }
        }
        if (this.path.isEmpty()) {
            if (this.parameters.getNumberOfParameter() > 0) {
                builder.append("?");
                builder.append(StringUtilities.concat("&", IterableUtilities.asList(this.parameters.parameters()).stream().map(p -> String.valueOf(p.getName()) + "=" + p.getValue()).collect(Collectors.toList())));
            } else {
                builder.append("/");
            }
        } else {
            builder.append(StringUtilities.concat("", this.path));
            if (this.parameters.getNumberOfParameter() > 0) {
                builder.append("?");
                builder.append(StringUtilities.concat("&", IterableUtilities.asList(this.parameters.parameters()).stream().map(p -> String.valueOf(p.getName()) + "=" + p.getValue()).collect(Collectors.toList())));
            }
        }
        if (this.fragment != null) {
            builder.append("#");
            builder.append(this.fragment);
        }
        return builder.toString();
    }

    @Override
    public String getHostname() {
        return Optional.of(this.authority).convert(a -> a.getHost()).convert(h -> h.getName()).get();
    }

    @Override
    public int getPort() {
        return Optional.of(this.authority).convert(a -> a.getHost()).convert(h -> h.getPort()).getOr(() -> -1);
    }

    @Override
    public String getPathString() {
        StringBuilder builder = new StringBuilder();
        builder.append(StringUtilities.concat("", this.path));
        return builder.toString();
    }

    @Override
    public String getUserName() {
        return Optional.of(this.authority).convert(a -> a.getAuthentication()).convert(a -> a.getUsername()).get();
    }

    @Override
    public String getPassword() {
        return Optional.of(this.authority).convert(a -> a.getAuthentication()).convert(a -> a.getPassword()).get();
    }
}

