/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.utilities.io.url.parser;

import net.anwiba.commons.lang.exception.CreationException;
import net.anwiba.commons.lang.object.ObjectPair;
import net.anwiba.commons.lang.optional.Optional;
import net.anwiba.commons.utilities.io.url.Authentication;
import net.anwiba.commons.utilities.io.url.Authority;
import net.anwiba.commons.utilities.io.url.Host;
import net.anwiba.commons.utilities.io.url.IAuthority;
import net.anwiba.commons.utilities.number.NumberUtilities;
import net.anwiba.commons.utilities.string.StringUtilities;

class AuthorityBuilder {
    private PairBuilder builder = null;
    private State state = State.FIRST;
    private ObjectPair<String, String> first;

    AuthorityBuilder() {
    }

    public IAuthority build() throws CreationException {
        switch (this.state) {
            case FIRST: {
                if (this.builder == null) {
                    return null;
                }
                ObjectPair<String, String> pair = this.builder.build();
                return new Authority(null, new Host(pair.getFirstObject(), this.port(pair.getSecondObject())));
            }
            case SECOND: {
                String username = Optional.of(this.first.getFirstObject()).accept(s -> !StringUtilities.isNullOrTrimmedEmpty(s)).convert(s -> s.trim()).get();
                String password = Optional.of(this.first.getSecondObject()).accept(s -> !StringUtilities.isNullOrEmpty(s)).get();
                if (this.builder == null) {
                    return new Authority(new Authentication(username, password), null);
                }
                return new Authority(new Authentication(username, password), this.host(this.builder.build()));
            }
        }
        return null;
    }

    private Host host(ObjectPair<String, String> pair) throws CreationException {
        if (pair == null) {
            return null;
        }
        return new Host(pair.getFirstObject(), this.port(pair.getSecondObject()));
    }

    private Integer port(String string) throws CreationException {
        if (StringUtilities.isNullOrTrimmedEmpty(string)) {
            return null;
        }
        if (!NumberUtilities.isNumber(string)) {
            throw new CreationException("No number '" + string + "'");
        }
        return Optional.of(string).convert(s -> Integer.valueOf(s)).get();
    }

    public void add(char character) {
        switch (this.state) {
            case FIRST: {
                if (character == '@') {
                    this.first = Optional.of(this.builder).convert(b -> b.build()).get();
                    this.state = State.SECOND;
                    this.builder = null;
                    return;
                }
                if (this.builder == null) {
                    this.builder = new PairBuilder();
                }
                this.builder.add(character);
                return;
            }
            case SECOND: {
                if (this.builder == null) {
                    this.builder = new PairBuilder();
                }
                this.builder.add(character);
                return;
            }
        }
    }

    public class PairBuilder {
        private StringBuilder builder = null;
        private State state = State.FIRST;
        private String name = null;

        public ObjectPair<String, String> build() {
            switch (this.state) {
                case FIRST: {
                    if (this.builder == null) {
                        return null;
                    }
                    return new ObjectPair<String, Object>(this.builder.toString(), null);
                }
                case SECOND: {
                    if (this.builder == null) {
                        return new ObjectPair<String, Object>(this.name, null);
                    }
                    return new ObjectPair<String, String>(this.name, this.builder.toString());
                }
            }
            return null;
        }

        public void add(char character) {
            switch (this.state) {
                case FIRST: {
                    if (character == ':') {
                        this.name = Optional.of(this.builder).convert(b -> b.toString()).get();
                        this.state = State.SECOND;
                        this.builder = null;
                        return;
                    }
                    if (this.builder == null) {
                        this.builder = new StringBuilder();
                    }
                    this.builder.append(character);
                    return;
                }
                case SECOND: {
                    if (this.builder == null) {
                        this.builder = new StringBuilder();
                    }
                    this.builder.append(character);
                    return;
                }
            }
        }
    }

    private static enum State {
        FIRST,
        SECOND;

    }
}

