/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.utilities.number;

import java.text.MessageFormat;

public class LongValueBuilder {
    private final StringBuilder valueStringBuilder = new StringBuilder();
    private boolean isNegativ = false;
    private final String originalString;

    public LongValueBuilder(String originalString) {
        this.originalString = originalString;
    }

    public void add(char c) {
        if (this.valueStringBuilder.length() < 17) {
            this.valueStringBuilder.append(c);
        }
    }

    public void setNegativ() {
        if (this.valueStringBuilder.length() != 0) {
            throw new NumberFormatException(MessageFormat.format("Unable to parse string ''{0}'' as Double.", this.originalString));
        }
        this.isNegativ = true;
    }

    public long build() {
        String valueString = this.valueStringBuilder.toString();
        if (valueString.length() == 0) {
            return 0L;
        }
        return Long.parseLong(valueString);
    }

    public int length() {
        return this.valueStringBuilder.length();
    }

    public boolean isNegativ() {
        return this.isNegativ;
    }
}

