/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.utilities.string;

import java.util.regex.Pattern;
import net.anwiba.commons.lang.functional.ConversionException;
import net.anwiba.commons.lang.functional.ResolvingException;
import net.anwiba.commons.utilities.provider.IContextValueProvider;
import net.anwiba.commons.utilities.regex.DoNothingStringConverter;
import net.anwiba.commons.utilities.regex.tokenizer.IRegExpTokenConverter;
import net.anwiba.commons.utilities.regex.tokenizer.RegExpTokenizingConverter;
import net.anwiba.commons.utilities.string.IStringAppender;
import net.anwiba.commons.utilities.string.IStringResolver;
import net.anwiba.commons.utilities.string.StringAppender;

public class AbstractStringResolver
implements IStringResolver {
    protected final IStringAppender errorHandler;
    private final IContextValueProvider<String, String, RuntimeException> provider;
    private final Pattern pattern;

    public AbstractStringResolver(IStringAppender errorHandler, Pattern pattern, IContextValueProvider<String, String, RuntimeException> contextValueProvider) {
        this.errorHandler = errorHandler;
        this.pattern = pattern;
        this.provider = contextValueProvider;
    }

    @Override
    public String resolve(String value) throws ResolvingException {
        return this.resolve(value, this.errorHandler);
    }

    private String resolve(String value, final IStringAppender errorHandler) throws ResolvingException {
        block3: {
            try {
                if (value != null) break block3;
                return null;
            }
            catch (ConversionException exception) {
                throw new ResolvingException(exception.getLocalizedMessage(), exception);
            }
        }
        final Pattern pattern = this.pattern;
        RegExpTokenizingConverter converter = new RegExpTokenizingConverter(new IRegExpTokenConverter(){

            @Override
            public String convert(String[] groups) {
                String name = groups[1];
                String defaultValue = groups.length > 2 ? groups[2] : null;
                return AbstractStringResolver.this.getValue(name, defaultValue, errorHandler);
            }

            @Override
            public Pattern getRegExpPattern() {
                return pattern;
            }
        }, new DoNothingStringConverter());
        return converter.convert(value, new StringAppender());
    }

    String getValue(String name, String defaultValue, IStringAppender errorHandler) {
        String value = this.provider.getValue(name);
        if (defaultValue == null && value == null) {
            errorHandler.append(name);
            return "";
        }
        return value != null ? value : defaultValue;
    }
}

