/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.utilities.string;

import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import net.anwiba.commons.lang.functional.IConverter;
import net.anwiba.commons.utilities.string.IStringSubstituter;
import net.anwiba.commons.utilities.string.StringUtilities;

public class PrefixToSystemPropertySubstituter
implements IStringSubstituter {
    private final List<IConverter<String, String, RuntimeException>> converters = new LinkedList<IConverter<String, String, RuntimeException>>();

    public PrefixToSystemPropertySubstituter(List<String> propertyNames) {
        new LinkedHashSet<String>(propertyNames).forEach(property -> {
            boolean bl = this.converters.add(string2 -> {
                String value = System.getProperty(property);
                if (StringUtilities.isNullOrTrimmedEmpty(value) || !string2.startsWith(value)) {
                    return string2;
                }
                return "$SYSTEM{" + property + "}" + string2.substring(value.length(), string2.length());
            });
        });
    }

    @Override
    public String substitute(String string) {
        String value = string;
        for (IConverter<String, String, RuntimeException> converter : this.converters) {
            value = converter.convert(value);
        }
        return value;
    }
}

