/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.utilities.string;

import net.anwiba.commons.ensure.Ensure;
import net.anwiba.commons.utilities.string.IStringAppender;

public class StringAppender
implements IStringAppender {
    private final String separator;
    private final StringBuffer stringBuffer = new StringBuffer();
    private boolean appended = false;

    public StringAppender() {
        this("");
    }

    public StringAppender(String separator) {
        Ensure.ensureArgumentNotNull(separator);
        this.separator = separator;
    }

    public String toString() {
        return this.stringBuffer.toString();
    }

    @Override
    public void append(int value) {
        this.append(String.valueOf(value));
    }

    @Override
    public void append(Iterable<String> values) {
        for (String value : values) {
            this.append(value);
        }
    }

    @Override
    public void append(String[] values) {
        String[] stringArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            this.append(value);
            ++n2;
        }
    }

    @Override
    public void append(String value) {
        if (this.appended) {
            this.stringBuffer.append(this.separator);
        } else {
            this.appended = true;
        }
        this.stringBuffer.append(value);
    }

    @Override
    public boolean isEmpty() {
        return this.stringBuffer.length() == 0;
    }
}

