/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.lang.comparable;

import java.text.Collator;
import java.util.Comparator;
import net.anwiba.commons.lang.comparable.NumberComparator;
import net.anwiba.commons.lang.comparable.SortItemIterator;

public final class AlpaNumericStringComparator
implements Comparator<String> {
    private final Comparator<Object> stringComparator = Collator.getInstance();
    private final Comparator<Number> numberComparator = new NumberComparator();

    @Override
    public int compare(String string, String other) {
        SortItemIterator iterator = new SortItemIterator(string);
        SortItemIterator otherIterator = new SortItemIterator(other);
        while (iterator.hasNext() && otherIterator.hasNext()) {
            char c;
            int compare;
            Object value = iterator.next();
            Object otherValue = otherIterator.next();
            if (value instanceof String && otherValue instanceof String) {
                compare = this.stringComparator.compare(value, otherValue);
                if (compare == 0) continue;
                return compare;
            }
            if (value instanceof Number && otherValue instanceof Number) {
                compare = this.numberComparator.compare((Number)value, (Number)otherValue);
                if (compare == 0) continue;
                return compare;
            }
            if (value.getClass() == otherValue.getClass() && value instanceof Comparable) {
                return ((Comparable)value).compareTo(otherValue);
            }
            if (value instanceof Number) {
                if (otherValue instanceof String && Character.isWhitespace(c = ((String)otherValue).charAt(0))) {
                    return 1;
                }
                return -1;
            }
            if (otherValue instanceof Number && value instanceof String && Character.isWhitespace(c = ((String)value).charAt(0))) {
                return -1;
            }
            return 1;
        }
        if (!iterator.hasNext() && !otherIterator.hasNext()) {
            return 0;
        }
        if (!iterator.hasNext()) {
            return -1;
        }
        return 1;
    }
}

