/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.lang.stream;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.IntFunction;
import net.anwiba.commons.lang.collection.IObjectList;
import net.anwiba.commons.lang.collection.ObjectList;
import net.anwiba.commons.lang.functional.IAcceptor;
import net.anwiba.commons.lang.functional.IAggregator;
import net.anwiba.commons.lang.functional.IAssimilator;
import net.anwiba.commons.lang.functional.IConsumer;
import net.anwiba.commons.lang.functional.IConverter;
import net.anwiba.commons.lang.functional.IFactory;
import net.anwiba.commons.lang.functional.IIterable;
import net.anwiba.commons.lang.functional.ISupplier;
import net.anwiba.commons.lang.optional.IOptional;
import net.anwiba.commons.lang.optional.Optional;
import net.anwiba.commons.lang.stream.FailedStream;
import net.anwiba.commons.lang.stream.IStream;
import net.anwiba.commons.lang.stream.IterableConvertingIterable;
import net.anwiba.commons.lang.stream.IterableCountingIterable;
import net.anwiba.commons.lang.stream.IterableFilteringIterable;
import net.anwiba.commons.lang.stream.IterableFlattingIterable;
import net.anwiba.commons.lang.stream.Streams;

class SequencedStream<T, E extends Exception>
implements IStream<T, E> {
    private final IIterable<T, E> iterable;
    private final Class<E> exceptionClass;

    SequencedStream(Class<E> exceptionClass, IIterable<T, E> iterable) {
        this.exceptionClass = exceptionClass;
        this.iterable = iterable;
    }

    @Override
    public <O> IStream<O, E> convert(IConverter<T, O, E> converter) {
        return new SequencedStream<T, E>(this.exceptionClass, new IterableConvertingIterable<Object, O, E>(this.iterable, i -> i != null, converter));
    }

    @Override
    public <O> IStream<O, E> convert(IAggregator<Integer, T, O, E> aggegator) {
        return new SequencedStream<T, E>(this.exceptionClass, new IterableCountingIterable<Object, O, E>(this.iterable, i -> i != null, aggegator));
    }

    @Override
    public IStream<T, E> distinct() {
        LinkedHashSet set = new LinkedHashSet();
        return this.filter(i -> set.add(i));
    }

    @Override
    public IStream<T, E> filter(IAcceptor<T> acceptor) {
        return new SequencedStream<T, E>(this.exceptionClass, new IterableFilteringIterable<T, E>(this.iterable, acceptor));
    }

    @Override
    public IStream<T, E> notNull() {
        return this.filter(v -> v != null);
    }

    @Override
    public <O> IStream<O, E> instanceOf(Class<O> clazz) {
        return this.filter(i -> clazz.isInstance(i)).convert((T i) -> clazz.cast(i));
    }

    @Override
    public IStream<T, E> foreach(IConsumer<T, E> consumer) {
        try {
            this.iterable.foreach(consumer);
            return this;
        }
        catch (Exception exception) {
            return SequencedStream.stream(this.exceptionClass, exception);
        }
    }

    @Override
    public IStream<T, E> foreach(IAssimilator<Integer, T, E> assimilator) {
        try {
            this.iterable.foreach(assimilator);
            return this;
        }
        catch (Exception exception) {
            return SequencedStream.stream(this.exceptionClass, exception);
        }
    }

    @Override
    public IStream<T, E> failed(ISupplier<Iterable<T>, E> supplier) {
        return this;
    }

    @Override
    public IOptional<T, E> first() {
        try {
            return Optional.of(this.exceptionClass, this.iterable.first((O v) -> true));
        }
        catch (Exception exception) {
            return SequencedStream.optional(this.exceptionClass, exception);
        }
    }

    @Override
    public IOptional<T, E> first(IAcceptor<T> acceptor) {
        try {
            return Optional.of(this.exceptionClass, this.iterable.first(acceptor));
        }
        catch (Exception exception) {
            return SequencedStream.optional(this.exceptionClass, exception);
        }
    }

    @Override
    public <O> IOptional<O, E> aggregate(O identity, IAggregator<O, T, O, E> aggegator) {
        try {
            return Optional.of(this.exceptionClass, this.iterable.aggregate(identity, aggegator));
        }
        catch (Exception exception) {
            return SequencedStream.optional(this.exceptionClass, exception);
        }
    }

    @Override
    public Iterable<T> asIterable() throws E {
        return this.iterable.aggregate(new LinkedList(), (R l, O t) -> {
            l.add(t);
            return l;
        });
    }

    @Override
    public Collection<T> asCollection() throws E {
        return this.asList();
    }

    @Override
    public <O> List<O> asList() throws E {
        return this.iterable.aggregate(new ArrayList(), (R l, O t) -> {
            l.add(t);
            return l;
        });
    }

    @Override
    public <O> Set<O> asSet() throws E {
        return this.iterable.aggregate(new LinkedHashSet(), (R l, O t) -> {
            l.add(t);
            return l;
        });
    }

    @Override
    public IObjectList<T> asObjectList() throws E {
        return new ObjectList(this.asList());
    }

    @Override
    public <O> O[] asArray(IntFunction<O[]> factory) throws E {
        return this.asList().toArray(factory.apply(this.asList().size()));
    }

    @Override
    public <K, V> Map<K, V> asMap(IFactory<T, K, E> keyFactrory, IFactory<T, V, E> valueFactrory) throws E {
        return this.iterable.aggregate(new LinkedHashMap(), (R l, O t) -> {
            l.put(keyFactrory.create(t), valueFactrory.create(t));
            return l;
        });
    }

    @Override
    public IStream<T, E> revert() {
        try {
            List list = this.asList();
            Collections.reverse(list);
            return Streams.of(this.exceptionClass, list);
        }
        catch (Exception exception) {
            return SequencedStream.stream(this.exceptionClass, exception);
        }
    }

    @Override
    public <O> IStream<O, E> flat(IConverter<T, Iterable<O>, E> converter) {
        return new SequencedStream<T, E>(this.exceptionClass, new IterableFlattingIterable<Object, O, E>(this.iterable, i -> i != null, converter));
    }

    private static <T, E extends Exception> IStream<T, E> stream(Class<E> exceptionClass, Exception exception) {
        if (exceptionClass.isInstance(exception)) {
            return new FailedStream(exceptionClass, exception);
        }
        if (exception instanceof RuntimeException) {
            throw (RuntimeException)exception;
        }
        throw new RuntimeException(exception.getMessage(), exception);
    }

    private static <T, E extends Exception> IOptional<T, E> optional(Class<E> exceptionClass, Exception exception) {
        if (exceptionClass.isInstance(exception)) {
            return Optional.failed(exceptionClass, exception);
        }
        if (exception instanceof RuntimeException) {
            throw (RuntimeException)exception;
        }
        throw new RuntimeException(exception.getMessage(), exception);
    }
}

