/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.logging.apache;

import java.util.logging.Level;
import net.anwiba.commons.logging.ILevel;
import net.anwiba.commons.logging.java.JavaLogging;

public enum LogLevel {
    ALL(Level.ALL),
    DEBUG(JavaLogging.create(ILevel.DEBUG)),
    FINEST(Level.FINEST),
    FINER(Level.FINER),
    FINE(Level.FINE),
    CONFIG(Level.CONFIG),
    INFO(JavaLogging.create(ILevel.INFO)),
    WARNING(JavaLogging.create(ILevel.WARNING)),
    ERROR(JavaLogging.create(ILevel.ERROR)),
    SEVERE(Level.SEVERE),
    OFF(Level.OFF);

    private final Level level;

    private LogLevel(Level level) {
        this.level = level;
    }

    public static LogLevel byLevel(Level level) {
        int limes = LogLevel.ALL.level.intValue();
        LogLevel[] logLevelArray = LogLevel.values();
        int n = logLevelArray.length;
        int n2 = 0;
        while (n2 < n) {
            LogLevel logLevel = logLevelArray[n2];
            if (limes < level.intValue() && level.intValue() <= logLevel.level.intValue()) {
                return logLevel;
            }
            limes = logLevel.level.intValue();
            ++n2;
        }
        return OFF;
    }
}

