/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.logging.java;

import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import net.anwiba.commons.logging.ILevel;
import net.anwiba.commons.logging.ILogger;
import net.anwiba.commons.logging.ILogging;
import net.anwiba.commons.logging.java.LevelFactory;
import net.anwiba.commons.logging.java.LoggerCover;

public class JavaLogging
implements ILogging {
    @Override
    public ILogger getLogger(String name) {
        return this.getLogger(name, null);
    }

    private ILogger getLogger(String name, String resourceBundleName) {
        LogManager manager = LogManager.getLogManager();
        Logger logger = manager.getLogger(name);
        if (logger != null) {
            return (ILogger)((Object)logger);
        }
        logger = new LoggerCover(name, resourceBundleName);
        manager.addLogger(logger);
        return (ILogger)((Object)logger);
    }

    @Override
    public void setHandler(Handler ... handlers) {
        Logger logger = this.getRootLogger();
        Handler[] handlerArray = handlers;
        int n = handlers.length;
        int n2 = 0;
        while (n2 < n) {
            Handler handler = handlerArray[n2];
            logger.addHandler(handler);
            ++n2;
        }
    }

    private Logger getRootLogger() {
        LogManager manager = LogManager.getLogManager();
        return manager.getLogger("");
    }

    @Override
    public void setLevel(Level level, String nameSpace) {
        ((Logger)((Object)this.getLogger(nameSpace))).setLevel(level);
    }

    public static Level create(ILevel level) {
        return LevelFactory.createLevel(level.getName(), level.intValue());
    }
}

