/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.message;

import java.time.LocalDateTime;
import java.util.TimeZone;
import net.anwiba.commons.ensure.Ensure;
import net.anwiba.commons.lang.optional.Optional;
import net.anwiba.commons.message.IMessage;
import net.anwiba.commons.message.MessageBuilder;
import net.anwiba.commons.message.MessageType;

public class Message
implements IMessage {
    private static final long serialVersionUID = 7859482730024022987L;
    private final String text;
    private final String description;
    private final MessageType messageType;
    private final Throwable throwable;
    LocalDateTime timeStamp = LocalDateTime.now(Optional.of(System.getProperty("user.timezone")).convert(z -> TimeZone.getTimeZone(z)).getOr(() -> TimeZone.getDefault()).toZoneId());

    public Message(String text, String description, Throwable throwable, MessageType messageType) {
        Ensure.ensureArgumentNotNull((Object)messageType);
        this.text = text;
        this.description = description;
        this.throwable = throwable;
        this.messageType = messageType;
    }

    public static IMessage create(String text, String description, MessageType messageType) {
        return new MessageBuilder().setInfo().setText(text).setDescription(description).setType(messageType).build();
    }

    public static IMessage create(String text, String description) {
        return new MessageBuilder().setInfo().setText(text).setDescription(description).setType(MessageType.DEFAULT).build();
    }

    public static IMessage create(String text) {
        return new MessageBuilder().setInfo().setText(text).setType(MessageType.DEFAULT).build();
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Throwable getThrowable() {
        return this.throwable;
    }

    @Override
    public MessageType getMessageType() {
        return this.messageType;
    }

    @Override
    public LocalDateTime getTimeStamp() {
        return this.timeStamp;
    }
}

