/*
 * Decompiled with CFR 0.152.
 */
package net.anwiba.commons.message.observer;

import java.util.ArrayList;
import java.util.List;
import net.anwiba.commons.message.IMessage;
import net.anwiba.commons.message.observer.IMessageAddedListener;
import net.anwiba.commons.message.observer.IObservableMessageCollector;

public final class ObservableMessageCollector
implements IObservableMessageCollector {
    private final List<IMessageAddedListener> listeners = new ArrayList<IMessageAddedListener>();

    @Override
    public void setNote(String note) {
    }

    @Override
    public void addMessage(IMessage message) {
        this.fireMessageAdded(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMessageAddedListener(IMessageAddedListener listener) {
        List<IMessageAddedListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeMessageAddedListener(IMessageAddedListener listener) {
        List<IMessageAddedListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireMessageAdded(IMessage message) {
        ArrayList<IMessageAddedListener> currentListeners;
        List<IMessageAddedListener> list = this.listeners;
        synchronized (list) {
            currentListeners = new ArrayList<IMessageAddedListener>(this.listeners);
        }
        for (IMessageAddedListener listener : currentListeners) {
            listener.messageAdded(message);
        }
    }
}

